/* $Id: BusinesscardServlet.java,v 1.1 2009/09/16 08:29:20 stm Exp $
 *
 * PDFlib client: hello servlet example in Java
 */

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

public class BusinessCardServlet extends HttpServlet {
    private static final long serialVersionUID = -5848023367439452579L;

    public void service(HttpServletRequest request, HttpServletResponse response)
            throws ServletException {
        pdflib p = null;
        int i, blockcontainer, page;
        String infile = "boilerplate.pdf";
        /*
         * This is where font/image/PDF input files live. Adjust as necessary.
         * 
         * Note that this directory must also contain the LuciduxSans font
         * outline and metrics files.
         */
        ServletContext context = getServletContext();
        String searchpath = context.getRealPath("/WEB-INF/data");

        /*
         * Catch problems that application data cannot be accessed.
         */
        if (searchpath == null) {
            throw new ServletException(
                    "Error: Unable to access application data (WAR file not unpacked?)");
        }

        String[][] data = { { "name", "Victor Kraxi" },
            { "business.title", "Chief Paper Officer" },
            { "business.address.line1", "17, Aviation Road" },
            { "business.address.city", "Paperfield" },
            { "business.telephone.voice", "phone +1 234 567-89" },
            { "business.telephone.fax", "fax +1 234 567-98" },
            { "business.email", "victor@kraxi.com" },
            { "business.homepage", "www.kraxi.com" }, };

        byte[] buf;
        ServletOutputStream out;

        try {
            p = new pdflib();

            // Generate a PDF in memory; insert a file name to create PDF on
            // disk
            if (p.begin_document("", "") == -1) {
                throw new ServletException("Error: " + p.get_apiname() + ": "
                        + p.get_errmsg());
            }

            /* Set the search path for fonts and PDF files */
            p.set_parameter("SearchPath", searchpath);

            p.set_info("Creator", "businesscardServlet.java");
            p.set_info("Author", "Thomas Merz");
            p.set_info("Title",
                            "PDFlib block processing sample (Java servlet)");

            blockcontainer = p.open_pdi_document(infile, "");
            if (blockcontainer == -1) {
                throw new ServletException("Error: " + p.get_apiname() + ": "
                        + p.get_errmsg());
            }

            page = p.open_pdi_page(blockcontainer, 1, "");
            if (page == -1) {
                throw new ServletException("Error: " + p.get_apiname() + ": "
                        + p.get_errmsg());
            }

            p.begin_page_ext(20, 20, ""); // dummy page size

            // This will adjust the page size to the block container's size.
            p.fit_pdi_page(page, 0, 0, "adjustpage");

            // Fill all text blocks with dynamic data
            for (i = 0; i < (int) data.length; i++) {
                if (p.fill_textblock(page, data[i][0], data[i][1],
                        "embedding encoding=unicode") == -1) {
                    System.err.println("Warning: " + p.get_errmsg());
                }
            }

            p.end_page_ext(""); // close page
            p.close_pdi_page(page);

            p.end_document(""); // close PDF document
            p.close_pdi_document(blockcontainer);

            buf = p.get_buffer();

            response.setContentType("application/pdf");
            response.setContentLength(buf.length);
            response.setHeader("Content-Disposition",
                    "inline; filename=businesscard.pdf");

            out = response.getOutputStream();
            out.write(buf);
            out.close();
        }
        catch (PDFlibException e) {
            throw new ServletException("PDFlib exception occurred in "
                    + getClass().getName(), e);
        }
        catch (Exception e) {
            throw new ServletException("Exception occurred in "
                    + getClass().getName(), e);
        }
        finally {
            if (p != null) {
                p.delete(); /* delete the PDFlib object */
            }
        }
    }
}
