/* $Id: chartabServlet.java,v 1.9 2004/05/17 12:47:19 rp Exp $
 *
 * PDFlib client: hello servlet example in Java
 */

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

public class ChartabServlet extends HttpServlet {
    private static final long serialVersionUID = 3971626551507089134L;

    /* change these as required */
    static final String fontname = "LuciduxSans-Oblique";

    /* list of encodings to use */
    static final String encodings[] = { "iso8859-1", "iso8859-2", "iso8859-15" };
    static final int ENCODINGS = 3;
    static final float FONTSIZE = 16;
    static final float TOP = 700;
    static final float LEFT = 50;
    static final float YINCR = 2 * FONTSIZE;
    static final float XINCR = 2 * FONTSIZE;

    public void service(HttpServletRequest request, HttpServletResponse response)
            throws ServletException {
        /* whether or not to embed the font */
        int embed = 1;

        String buf;
        String optlist;
        float x, y;
        int row, col, font, page;

        pdflib p = null;
        byte[] outbuf;
        ServletOutputStream out;

        /* This is where font/image/PDF input files live. Adjust as necessary. */
        ServletContext context = getServletContext();
        String searchpath = context.getRealPath("/WEB-INF/data");

        /*
         * Catch problems that application data cannot be accessed.
         */
        if (searchpath == null) {
            throw new ServletException(
                    "Error: Unable to access application data (WAR file not unpacked?)");
        }

        try {
            p = new pdflib();

            // Generate a PDF in memory; insert a file name to create PDF on
            // disk
            if (p.begin_document("", "") == -1) {
                throw new ServletException("Error: " + p.get_apiname() + ": "
                        + p.get_errmsg());
            }

            p.set_parameter("openaction", "fitpage");
            p.set_parameter("fontwarning", "true");

            p.set_parameter("SearchPath", searchpath);

            p.set_info("Creator", "chartabServlet.java");
            p.set_info("Author", "Thomas Merz");
            p.set_info("Title", "Character table (Java/Servlet)");

            /* loop over all encodings */
            for (page = 0; page < ENCODINGS; page++) {
                p.begin_page_ext(595, 842, ""); /* start a new page */

                /* print the heading and generate the bookmark */
                font = p.load_font("Helvetica", "unicode", "");
                p.setfont(font, FONTSIZE);
                if (embed == 1) {
                    buf = fontname + " (" + encodings[page] + ") embedded";
                }
                else {
                    buf = fontname + " (" + encodings[page] + ") not embedded";
                }

                p.show_xy(buf, LEFT - XINCR, TOP + 3 * YINCR);
                p.create_bookmark(buf, "");

                /* print the row and column captions */
                p.setfont(font, 2 * FONTSIZE / 3);

                for (row = 0; row < 16; row++) {
                    buf = "x" + (Integer.toHexString(row)).toUpperCase();
                    p.show_xy(buf, LEFT + row * XINCR, TOP + YINCR);

                    buf = (Integer.toHexString(row)).toUpperCase() + "x";
                    p.show_xy(buf, LEFT - XINCR, TOP - row * YINCR);
                }

                /* print the character table */
                if (embed == 1) {
                    optlist = "embedding";
                }
                else {
                    optlist = "";
                }
                font = p.load_font(fontname, encodings[page], optlist);
                p.setfont(font, FONTSIZE);

                y = TOP;
                x = LEFT;

                for (row = 0; row < 16; row++) {
                    for (col = 0; col < 16; col++) {
                        buf = String.valueOf((char) (16 * row + col));
                        p.show_xy(buf, x, y);
                        x += XINCR;
                    }
                    x = LEFT;
                    y -= YINCR;
                }

                p.end_page_ext(""); /* close page */
            }
            p.end_document(""); /* close PDF document */

            outbuf = p.get_buffer();

            response.setContentType("application/pdf");
            response.setContentLength(outbuf.length);
            response.setHeader("Content-Disposition",
                    "inline; filename=chartab.pdf");

            out = response.getOutputStream();
            out.write(outbuf);
            out.close();
        }
        catch (PDFlibException e) {
            throw new ServletException("PDFlib exception occurred in "
                    + getClass().getName(), e);
        }
        catch (Exception e) {
            throw new ServletException("Exception occurred in "
                    + getClass().getName(), e);
        }
        finally {
            if (p != null) {
                p.delete(); /* delete the PDFlib object */
            }
        }
    }
}
