/* $Id: starter_pdfx5g.java,v 1.1 2009/09/10 13:13:11 stm Exp $
 *
 * PDF/X-5g starter:
 * Create PDF/X-5g conforming output with a reference to an external page
 *
 * The external document from which a page is referenced must conform to
 * one of the following standards:
 * PDF/X-1a:2003, PDF/X-3:2002, PDF/X-4, PDF/X-4p, PDF/X-5g, or PDF/X-5pg
 *
 * In order to properly display and print the referenced target page with
 * Acrobat you must configure Acrobat appropriately (see PDFlib Tutorial),
 * and the target PDF must be available to Acrobat.
 *
 * Required software: PDFlib/PDFlib+PDI/PPS 8
 * Required data: font file, external PDF/X target, ICC output intent profile
 *                (see www.pdflib.com for ICC profiles)
 */

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

class starter_pdfx5g {
    public static void main(String argv[]) {
        final String searchpath = "../data";
        final String targetname = "x5target.pdf";

        pdflib p = null;
        String optlist;

        int font, proxy;
        double linewidth = 2;
        double width, height;

        try {
            p = new pdflib();

            /* This means we must check return values of load_font() etc. */
            p.set_parameter("errorpolicy", "return");

            p.set_parameter("SearchPath", searchpath);

            if (p.begin_document("starter_pdfx5g.pdf", "pdfx=PDF/X-5g") == -1) {
                throw new Exception("Error: " + p.get_errmsg());
            }

            p.set_info("Creator", "PDFlib starter sample");
            p.set_info("Title", "starter_pdfx5g");

            /* Open the output intent profile */
            if (p.load_iccprofile("ISOcoated.icc", "usage=outputintent") == -1) {
                System.err.print("Error: " + p.get_errmsg() + "\n");
                System.err.print("Please install the ICC profile package from "
                        + "www.pdflib.com to run the PDF/X starter sample.\n");
                p.delete();
                System.exit(2);
            }

            /* Font embedding is required for PDF/X */
            font = p.load_font("LuciduxSans-Oblique", "winansi", "embedding");

            if (font == -1) {
                throw new Exception("Error: " + p.get_errmsg());
            }

            /*
             * Create a template which will serve as proxy. The referenced
	     * page (the target) is attached to the proxy.
	     * The template width and height will be determined automatically,
	     * so we don't have to supply them.
             */
            optlist = "reference={filename=" + targetname + " pagenumber=1}";
            proxy = p.begin_template_ext(0, 0, optlist);

            if (proxy == -1) {
                throw new Exception("Error: " + p.get_errmsg());
            }

	    width  = p.info_image(proxy, "imagewidth", "");
	    height = p.info_image(proxy, "imageheight", "");

            /*
             * Draw a crossed-out rectangle to visualize the proxy. Attention:
             * if we use the exact corner points, one half of the linewidth
             * would end up outside the template, and therefore be clipped.
             */
            p.setlinewidth(linewidth);
            p.moveto(linewidth / 2,  linewidth / 2);
            p.lineto(width - linewidth / 2,  linewidth / 2);
            p.lineto(width - linewidth / 2, height - linewidth / 2);
            p.lineto(linewidth / 2, height - linewidth / 2);
            p.lineto(linewidth / 2,  linewidth / 2);
            p.lineto(width - linewidth / 2, height - linewidth / 2);

            p.moveto(width - linewidth / 2,  linewidth / 2);
            p.lineto(linewidth / 2, height - linewidth / 2);
            p.stroke();

            p.setfont(font, 24);

            optlist = "fitmethod=auto position=center boxsize={" + width + " "
                    + height + "}";
            p.fit_textline("Proxy replaces target here", 0, 0, optlist);

            p.end_template_ext(0, 0);

            /* Create the page */
            p.begin_page_ext(595, 842, "");

            p.setfont(font, 18);

            p.fit_textline(
                "PDF/X-5 starter sample with reference to an external page",
                50, 700, "");

            /* Place the proxy on the page */
            p.fit_image(proxy, 50, 50, "boxsize={500 500} fitmethod=meet");

            p.end_page_ext("");
            p.end_document("");
        }
        catch (PDFlibException e) {
            System.err.print("PDFlib exception occurred:\n");
            System.err.print("[" + e.get_errnum() + "] " + e.get_apiname()
                    + ": " + e.get_errmsg() + "\n");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        finally {
            if (p != null) {
                p.delete();
            }
        }
    }
}
