require 'PDFlib'
begin
    p = PDFlib.new
    p.set_parameter("errorpolicy", "exception")
    p.begin_document("", "")
    p.set_info("Creator", "hello.rb")
    p.set_info("Author", "Thomas Merz")
    p.set_info("Title", "Hello world (Ruby)!")
    p.begin_page_ext(595, 842, "")
    font = p.load_font("Helvetica-Bold", "winansi", "")
    p.setfont(font, 24)
    p.set_text_pos(50, 700)
    p.show("Hello world!")
    p.continue_text("(says Ruby)")
    p.end_page_ext("")
    p.end_document("")

    send_data p.get_buffer(), :filename => "hello.pdf",
	:type => "application/pdf", :disposition => "inline"
rescue  PDFlibException => pe
    # error handling
    print "PDFlib exception occurred in hello-rails sample:\n"
    print "[" + pe.get_errnum.to_s + "] " + pe.get_apiname + \
		  ": " + pe.get_errmsg + "\n"
end
