#!/usr/bin/env ruby
# $Id: starter_3d.rb,v 1.3.2.3 2011/06/06 11:32:12 rjs Exp $
# 3D Starter:
# Load a 3D model and create a 3D annotation from it.
#
# Define a 3D view and load some 3D data with the view defined. Then create
# an annotation containing the loaded 3D data with the defined 3D view as the
# initial view.
#
# Required software: PDFlib/PDFlib+PDI/PPS 8.0.3
# Required data: PRC data file

require './PDFlib'

# This is where the data files are. Adjust if necessary.
searchpath = "../data"
outfile = "starter_3d.pdf"

begin
    p = PDFlib.new

	p.set_parameter("SearchPath", searchpath)

	# This means we must check return values of load_font() etc.
	p.set_parameter("errorpolicy", "return")


	# Start the document
	if (p.begin_document(outfile, "compatibility=1.7ext3") == -1)
	    raise "Error: " + p.get_errmsg()
	end

	p.set_info("Creator", "PDFlib Cookbook")
	p.set_info("Title", "Starter 3D")

	font = p.load_font("Helvetica", "winansi", "")
	if font == -1
	    raise "Error: " + p.get_errmsg + "\n"
	end

	p.begin_page_ext(0, 0, "width=a4.width height=a4.height")

	# Define a 3D view which shows the model from the top
	optlist = "type=PRC name=FirstView background={fillcolor=Lavender} " + \
		"camera2world={-1 0 0 0 1 0 0 0 -1 0.5 0 300}"
	if ((view = p.create_3dview("First view", optlist)) == -1)
		raise "Error: " + p.get_errmsg + "\n"
	end

	# Load some 3D data with the view defined above
	data = p.load_3ddata("riemann.prc", "type=PRC views={" + view.to_s + "}")
	if data == -1
		raise "Error: " + p.get_errmsg + "\n"
	end

	# Create an annotation containing the loaded 3D data with the
	# defined 3D view as the initial view

	optlist = "name=annot usercoordinates contents=PRC 3Ddata= " + \
	    data.to_s + " 3Dactivate={enable=open} 3Dinitialview=" + \
	    view.to_s
	p.create_annotation(116, 400, 447, 580, "3D", optlist)

	p.end_page_ext("")

	p.end_document("")

rescue  PDFlibException => pe
  print "PDFlib exception occurred:\n"
  print "[" + pe.get_errnum.to_s + "] " + pe.get_apiname + \
		": " + pe.get_errmsg + "\n"
rescue  Exception => e
  print e.backtrace.join("\n") + "\n" + e.to_s
ensure
  p.delete() if p
end

# vim: sw=4
