#!/usr/bin/env ruby -w
# encoding: utf-8
#
# $Id: starter_basic.rb,v 1.7.2.2 2011/02/17 10:56:21 rp Exp $
#
# Basic starter:
# Create some simple text, vector graphics and image output
#
# required software: PDFlib/PDFlib+PDI/PPS 7
# required data: none
#

require './PDFlib'

# This is where the data files are. Adjust as necessary.
searchpath = "../data"

imagefile = "nesrin.jpg"

begin
  p = PDFlib.new

  # This means we must check return values of load_font() etc.
  p.set_parameter("errorpolicy", "return")

  p.set_parameter("SearchPath", searchpath)

  # we use "bytes" as textformat, this allows to use unicode encoding
  p.set_parameter("textformat", "bytes");

  if (p.begin_document("starter_basic.pdf", "") == -1)
    raise "Error: " + p.get_errmsg()
  end

  p.set_info("Creator", "PDFlib starter sample")
  p.set_info("Title", "starter_basic")

  # We load the image before the first page, and use it
  # on all pages
  #
  image = p.load_image("auto", imagefile, "")

  if (image == -1)
    raise "Error: " + p.get_errmsg()
  end

  # Page 1
  p.begin_page_ext(595, 842, "")

  # use DejaVuSerif font with text format UTF-8 for placing the text
  # and demonstrate various options how to pass the UTF-8 text to PDFlib
  #
  optlist = "fontname={DejaVuSerif} embedding fontsize=24 " +
	    "encoding=unicode textformat=utf8";

  # plain ASCII text
  p.fit_textline("en: Hello!", 50, 700, optlist);
  # using Character Escapes */
  p.fit_textline("\x67\x72\x3A\x20\xCE\x93\xCE\xB5\xCE\xB9\xCE\xAC\x21",
	    50, 650, optlist);
  # plain UTF-8 text
  p.fit_textline("ru: Привет!", 50, 600, optlist);
  # using PDFlib's character references
  p.fit_textline("es: &#xA1;Hola!", 50, 550, optlist + " charref=true");


  p.fit_image(image,  0.0,  0.0, "scale=0.25")

  p.end_page_ext("")

  # Page 2
  p.begin_page_ext(595, 842, "")

  # red rectangle
  p.setcolor("fill", "rgb", 1.0, 0.0, 0.0, 0.0)
  p.rect(200, 200, 250, 150)
  p.fill()

  # blue circle
  p.setcolor("fill", "rgb", 0.0, 0.0, 1.0, 0.0)
  p.arc(400, 600, 100, 0, 360)
  p.fill()

  # thick gray line
  p.setcolor("stroke", "gray", 0.5, 0.0, 0.0, 0.0)
  p.setlinewidth(10)
  p.moveto(100, 500)
  p.lineto(300, 700)
  p.stroke()

  # Using the same image handle means the data will be copied
  # to the PDF only once, which saves space.
  #
  p.fit_image(image, 150.0, 25.0, "scale=0.25")
  p.end_page_ext("")

  # Page 3
  p.begin_page_ext(595, 842, "")

  # Fit the image to a box of predefined size (without distortion)
  optlist = "boxsize={400 400} position={center} fitmethod=meet"

  p.fit_image(image, 100, 200, optlist)

  p.end_page_ext("")

  p.close_image(image)
  p.end_document("")

rescue  PDFlibException => pe
  print "PDFlib exception occurred:\n"
  print "[" + pe.get_errnum.to_s + "] " + pe.get_apiname + \
		": " + pe.get_errmsg + "\n"
rescue  Exception => e
  print e.backtrace.join("\n") + "\n" + e.to_s
ensure
  p.delete() if p
end
# vim: sw=2
