#!/usr/bin/env ruby
# $Id: starter_tagged.rb,v 1.6.10.1 2011/02/17 10:56:21 rp Exp $
#
# Tagged PDF starter:
# Create document with structure information for reflow and accessibility
#
# required software: PDFlib/PDFlib+PDI/PPS 7
# required data: none (dummy text created in program)
#/

require './PDFlib'


# This is where the data files are. Adjust as necessary.
String searchpath = "../data"

begin
  p = PDFlib.new

  # This means we must check return values of load_font() etc.
  p.set_parameter("errorpolicy", "return")

  p.set_parameter("SearchPath", searchpath)

  if (p.begin_document("starter_tagged.pdf", "tagged=true lang=en") == -1)
    raise "Error: " + p.get_errmsg()
  end

  p.set_info("Creator", "PDFlib starter sample")
  p.set_info("Title", "starter_tagged")

  # Automatically create spaces between chunks of text
  p.set_parameter("autospace", "true")

  # open the first structure element as a child of the document
  # structure root (=0)
  #
  id = p.begin_item("Document",
	"Title = {Starter sample for Tagged PDF}")

  p.begin_page_ext(0, 0,
	"width=a4.width height=a4.height taborder=structure")

  p.create_bookmark("Section 1", "")

  font = p.load_font("Helvetica", "winansi", "")

  if font == -1
    raise "Error: " + p.get_errmsg + "\n"
  end

  p.setfont(font, 24.0)

  id2 = p.begin_item("H1", "Title = {Introduction}")
  p.show_xy("1 Introduction", 50, 700)
  p.end_item(id2)

  id2 = p.begin_item("P", "Title = {Simple paragraph}")
  p.setfont(font, 12.0)
  p.continue_text("This PDF has a very simple document structure ")
  p.continue_text("which demonstrates basic Tagged PDF features ")
  p.continue_text("for accessibility.")

  p.end_item(id2)

  # The page number is created as an artifact; it will be
  # ignored when reflowing the page in Acrobat.
  #
  id_artifact = p.begin_item("Artifact", "")
  p.show_xy("Page 1", 250, 100)
  p.end_item(id_artifact)

  p.end_page_ext("")

  p.end_item(id)
  p.end_document("")

rescue  PDFlibException => pe
  print "PDFlib exception occurred:\n"
  print "[" + pe.get_errnum.to_s + "] " + pe.get_apiname + \
		  ": " + pe.get_errmsg + "\n"
rescue  Exception => e
  print e.backtrace.join("\n") + "\n" + e.to_s
ensure
  p.delete() if p
end

# vim: sw=2
