#!/bind/sh
# $Id: starter_3d.tcl,v 1.4.2.2 2011/05/10 18:15:42 rjs Exp $
# 3D Starter:
# Load a 3D model and create a 3D annotation from it.
# Hide the exec to Tcl but not to the shell by appending a backslash\
exec tclsh "$0" ${1+"$@"}

#
# Define a 3D view and load some 3D data with the view defined. Then create
# an annotation containing the loaded 3D data with the defined 3D view as the
# initial view.
#
# Required software: PDFlib/PDFlib+PDI/PPS 8.0.3
# Required data: PRC data file
#

# The lappend line is unnecessary if PDFlib has been installed
# in the Tcl package directory
set auto_path [linsert $auto_path 0 .libs .]

package require pdflib 8.0

# This is where the data files are. Adjust if necessary.
set searchpath "../data"
set outfile "starter_3d.pdf"

# create a new PDFlib object
set p [PDF_new]


if { [catch { 

    PDF_set_parameter $p "SearchPath" $searchpath

    # This means we must check return values of load_font() etc.
    PDF_set_parameter $p "errorpolicy" "return"

    # Start the document
    if {[PDF_begin_document $p $outfile "compatibility=1.7ext3"] == -1} {
        puts stderr "Error:  [PDF_get_errmsg $p]"
	exit
    }

    PDF_set_info $p "Creator" "PDFlib Cookbook"
    PDF_set_info $p "Title" "starter_3d"

    set font [PDF_load_font $p "Helvetica" "winansi" ""]
    if {$font == -1} {
        puts stderr "Error:  [PDF_get_errmsg $p]"
	exit
    }

    PDF_begin_page_ext $p 0 0 "width=a4.width height=a4.height"

    # Define a 3D view which shows the model from the top
    set optlist "type=PRC name=FirstView background={fillcolor=Lavender} camera2world={-1 0 0 0 1 0 0 0 -1 0.5 0 300}"
    set view [PDF_create_3dview $p "First view" $optlist]
    if {$view == -1} {
        puts stderr "Error:  [PDF_get_errmsg $p]"
	exit
    }

    # Load some 3D data with the view defined above
    set buf [format "type=PRC views={%d}" $view ]
    set data [PDF_load_3ddata $p "riemann.prc" $buf]
    if {$data == -1} {
        puts stderr "Error:  [PDF_get_errmsg $p]"
	exit
    }

    # Create an annotation containing the loaded 3D data with the
    # defined 3D view as the initial view
    #
    set buf [format "name=annot usercoordinates contents=PRC 3Ddata=%d 3Dactivate={enable=open} 3Dinitialview=%d" $data  $view]
    PDF_create_annotation $p 116 200 447 580 "3D" $buf

    PDF_end_page_ext $p ""

    PDF_end_document $p ""

} result] } {
    puts stderr "$result"
}

# delete the PDFlib object
PDF_delete $p

