#!/bin/sh
# $Id: starter_block.tcl,v 1.8 2009/09/16 16:20:39 rjs Exp $
#
# Hide the exec to Tcl but not to the shell by appending a backslash\
exec tclsh "$0" ${1+"$@"}

# Block starter:
# Import a PDF page containing blocks and fill text and image
# blocks with some data. For each addressee of the simulated
# mailing a separate page with personalized information is
# generated.
# A real-world application would of course fill the blocks with data
# retrieved from some external data source.
#
# Required software: PPS 8 or above
# Required data: input PDF, image

# The linsert line is unnecessary if PDFlib has been installed
# in the Tcl package directory
set auto_path [linsert $auto_path 0 .libs .]

package require pdflib 8.0

# This is where the data files are. Adjust as necessary.


# This is where the data files are. Adjust as necessary.
set searchpath "../data"
set outfile "starter_block.pdf"
set infile "block_template.pdf"
set imagefile "new.jpg"

# Names of the person-related blocks contained on the imported page
set addressblocks(0) "name"
set addressblocks(1) "street"
set addressblocks(2) "city"

set nblocks 3

# Data related to various persons used for personalization
set persons(0,0) "Mr Maurizio Moroni"
set persons(0,1) "Strada Provinciale 124"
set persons(0,2) "Reggio Emilia"
set persons(1,0) "Ms Dominique Perrier"
set persons(1,1) "25, rue Lauriston"
set persons(1,2) "Paris"
set persons(2,0) "Mr Liu Wong"
set persons(2,1) "55 Grizzly Peak Rd."
set persons(2,2) "Butte"

# Static text simulates database-driven variable contents
set intro "Dear"
set goodbye "Yours sincerely,\nVictor Kraxi"
set announcement \
"Our <fillcolor=red>BEST PRICE OFFER<fillcolor=black> includes today:\
\n\n\
Long Distance Glider\nWith this paper rocket you can send all your \
messages even when sitting in a hall or in the cinema pretty near \
the back.\n\n\
Giant Wing\nAn unbelievable sailplane! It is amazingly robust and \
can even do aerobatics. But it is best suited to gliding.\n\n\
Cone Head Rocket\nThis paper arrow can be thrown with big swing. \
We launched it from the roof of a hotel. It stayed in the air a \
long time and covered a considerable distance.\n\n\
Super Dart\nThe super dart can fly giant loops with a radius of 4 \
or 5 meters and cover very long distances. Its heavy cone point is \
slightly bowed upwards to get the lift required for loops.\n\n\
Visit us on our Web site at www.kraxi.com!"


set p [PDF_new]

if { [catch {

    PDF_set_parameter $p "SearchPath" $searchpath

    # This means we must check return values of load_font() etc.
    PDF_set_parameter $p "errorpolicy" "return"

    if {[PDF_begin_document $p $outfile \
            "destination={type=fitwindow} pagelayout=singlepage"] == -1} {
	puts stderr [format "Error: %s\n" [PDF_get_errmsg $p]]
	exit
    }

    PDF_set_info $p "Creator" "PDFlib starter sample"
    PDF_set_info $p "Title" "starter_block"

    # Open the Block template which contains PDFlib Blocks
    set indoc [PDF_open_pdi_document $p $infile ""]
    if {$indoc == -1} {
	puts stderr [format "Error: %s\n" [PDF_get_errmsg $p]]
	exit
    }

    # Open the first page and clone the page size
    set inpage [PDF_open_pdi_page $p $indoc 1 "cloneboxes"]
    if {$inpage == -1} {
	puts stderr [format "Error: %s\n" [PDF_get_errmsg $p]]
	exit
    }

    set image [PDF_load_image $p "auto" $imagefile ""]

    if {$image == -1} {
	puts stderr [format "Error: %s\n" [PDF_get_errmsg $p]]
	exit
    }

    # Based on the imported page generate several pages with the blocks
    # being filled with data related to different persons
    for {set i 0} {$i < $nblocks} {incr i} {
        # Start the output page with a dummy size
        PDF_begin_page_ext $p 10 10 ""

        # Place the imported page on the output page, and clone all
        # page boxes which are present in the input page; this will
        # override the dummy size used in begin_page_ext().
        PDF_fit_pdi_page $p $inpage 0 0 "cloneboxes"

        # Option list for text blocks
        set optlist "encoding=winansi embedding"

        # Loop over all person-related blocks. Fill the j-th block with the
        # corresponding entry of the persons array.
	for {set j 0} {$j < $nblocks} {incr j} {
            if {[PDF_fill_textblock $p $inpage $addressblocks($j) \
                    $persons($i,$j) $optlist] == -1} {
		puts [format "Warning: %s\n" [PDF_get_errmsg $p]]
            }
        }

        # Fill the "intro" block
        set buf [format "%s %s,"  $intro  $persons($i,0)]
        if {[PDF_fill_textblock $p $inpage "intro" $buf $optlist] == -1} {
            puts [format "Warning: %s\n" [PDF_get_errmsg $p]]
        }

        # Fill the "announcement" block
        if {[PDF_fill_textblock $p $inpage "announcement" $announcement \
                $optlist] == -1} {
            puts [format "Warning: %s\n" [PDF_get_errmsg $p]]
        }

        # Fill the "goodbye" block
        if {[PDF_fill_textblock $p $inpage "goodbye" $goodbye \
                $optlist] == -1} {
            puts [format "Warning: %s\n" [PDF_get_errmsg $p]]
        }

        # Fill the image block
        if {[PDF_fill_imageblock $p $inpage "icon" $image ""] == -1} {
            puts [format "Warning: %s\n" [PDF_get_errmsg $p]]
        }

        PDF_end_page_ext $p ""
    }

    PDF_close_pdi_page $p $inpage
    PDF_close_pdi_document $p $indoc
    PDF_close_image $p $image

    PDF_end_document $p ""

} result] } {
    puts stderr "$result"
}

# delete the PDFlib object
PDF_delete $p
