#!/bin/sh
# $Id: starter_block.tcl,v 1.6 2008/07/29 11:19:30 rjs Exp $
#
# Hide the exec to Tcl but not to the shell by appending a backslash\
exec tclsh "$0" ${1+"$@"}

# Starter sample for fallback fonts
#
# Required software: PDFlib/PDFlib+PDI/PPS 8
# Required data: suitable fonts, Japanese CMaps
#

# The linsert line is unnecessary if PDFlib has been installed
# in the Tcl package directory
set auto_path [linsert $auto_path 0 .libs .]

package require pdflib 8.0


# This is where the data files are. Adjust as necessary.
set searchpath "../data"
set outfile "starter_fallback.pdf"

set llx 50
set lly 50
set urx 800
set ury 550

set header(0) "Use case"
set header(1) "Option list for the 'fallbackfonts' option"
set header(2) "Base font"
set header(3) "With fallback font"

set MAXCOL 4

# struct testcases
set usecase 0
set fontname 1
set encoding 2
set fallbackoptions 3
set text 4

# Add Euro glyph to an encoding which doesn't support it
set testcases(0,0) "Extend 8-bit encoding"
set testcases(0,1) "Helvetica"
set testcases(0,2) "iso8859-1"
set testcases(0,3) "{fontname=Helvetica encoding=unicode forcechars=euro}"
# Reference Euro glyph by name (since it is missing from the encoding)
set testcases(0,4) "123&euro;"

set testcases(1,0) "Use Euro glyph from another font"
set testcases(1,1) "Courier"
set testcases(1,2) "winansi"
set testcases(1,3) "{fontname=Helvetica encoding=unicode forcechars=euro textrise=-5%}"
set testcases(1,4) "123&euro;"

set testcases(2,0) "Enlarge all glyphs in a font"
set testcases(2,1) "Times-Italic"
set testcases(2,2) "winansi"
# Enlarge all glyphs to better match other fonts of the same point size
set testcases(2,3) "{fontname=Times-Italic encoding=unicode forcechars={U+0020-U+00FF} fontsize=120%}"
set testcases(2,4) "font size"

set testcases(3,0) "Add enlarged pictogram"
set testcases(3,1) "Times-Roman"
set testcases(3,2) "unicode"
# pointing hand pictogram
set testcases(3,3) "{fontname=ZapfDingbats encoding=unicode forcechars=.a12 fontsize=150% textrise=-15%}"
set testcases(3,4) "Bullet symbol: &.a12;"

set testcases(4,0) "Add enlarged symbol glyph"
set testcases(4,1) "Times-Roman"
set testcases(4,2) "unicode"
set testcases(4,3) "{fontname=Symbol encoding=unicode forcechars=U+2663 fontsize=125%}"
set testcases(4,4) "Club symbol: &#x2663;"

# Greek characters missing in the font will be pulled from Symbol font
set testcases(5,0) "Add Greek characters to Latin font"
set testcases(5,1) "Times-Roman"
set testcases(5,2) "unicode"
set testcases(5,3) "{fontname=Symbol encoding=unicode}"
set testcases(5,4) "Greek text: &#x039B;&#x039F;&#x0393;&#x039F;&#x03A3;"

# Font with end-user defined character (EUDC)
set testcases(6,0) "Gaiji with EUDC font"
set testcases(6,1) "KozMinProVI-Regular"
set testcases(6,2) "unicode"
set testcases(6,3) "{fontname=EUDC encoding=unicode forcechars=U+E000 fontsize=140% textrise=-20%}"
set testcases(6,4) "Gaiji: &#xE000;"

# SING fontlet containing a single gaiji character
set testcases(7,0) "Gaiji with SING font"
set testcases(7,1) "KozMinProVI-Regular"
set testcases(7,2) "unicode"
set testcases(7,3) "{fontname=PDFlibWing encoding=unicode forcechars=gaiji}"
set testcases(7,4) "Gaiji: &#xE000;"

set testcases(8,0) "Replace Latin characters in CJK font"
set testcases(8,1) "KozMinProVI-Regular"
set testcases(8,2) "unicode"
set testcases(8,3) "{fontname=Courier-Bold encoding=unicode forcechars={U+0020-U+007E}}"
set testcases(8,4) "Latin and &#x65E5;&#x672C;&#x8A9E;"

# Requires "Unicode BMP Fallback SIL" font in fallback.ttf
# Identify missing glyphs caused by workflow problems
set testcases(9,0) "Identify missing glyphs"
set testcases(9,1) "Times-Roman"
set testcases(9,2) "unicode"
# deliberately use characters which are not available in the base font
set testcases(9,3) "{fontname=fallback encoding=unicode}"
set testcases(9,4) "Missing glyphs: &#x1234; &#x672C; &#x8A9E;"

set n_testcases 10

# create a new PDFlib object
set p [PDF_new]

if { [catch {

    PDF_set_parameter $p "SearchPath" $searchpath
    PDF_set_parameter $p "charref" "true"
    PDF_set_parameter $p "glyphcheck" "replace"

    # This means that formatting and other errors will raise an
    # exception. This simplifies our sample code, but is not
    # recommended for production code.
    
    PDF_set_parameter $p "errorpolicy" "exception"

    # Set an output path according to the name of the topic
    if {[PDF_begin_document $p $outfile ""] == -1} {
	puts stderr [format "Error: %s\n" [PDF_get_errmsg $p]]
	exit
    }

    PDF_set_info $p "Creator" "PDFlib starter sample"
    PDF_set_info $p "Title" "starter_fallback"

    # Start Page
    PDF_begin_page_ext $p 0 0 "width=a4.height height=a4.width"

    set table -1
    set col 1

    # Table header
    for {set row 1} {$col <= $MAXCOL} {incr col} {
	set optlist "fittextline={fontname=Helvetica-Bold encoding=unicode \
fontsize=11} margin=4"
       
	set table [PDF_add_table_cell $p $table $col $row $header([expr $col-1]) \
		$optlist]
    }

    # Create fallback samples, one use case per row
    set row 2
    for {set test 0} {$test < $n_testcases} {incr row
					     incr test} {
	set col 1

	# Column 1: description of the use case
	set optlist "fittextline={fontname=Helvetica encoding=unicode \
fontsize=11} margin=4"
	set table [PDF_add_table_cell $p $table $col $row \
	    $testcases($test,$usecase) $optlist]
	incr col

	# Column 2: reproduce option list literally
	set optlist "fittextline={fontname=Helvetica encoding=unicode \
fontsize=10} margin=4"
	set table [PDF_add_table_cell $p $table $col $row \
		$testcases($test,$fallbackoptions) $optlist]
	incr col

	# Column 3: text with base font
	set optlist [format "fittextline={fontname=%s encoding=%s fontsize=11 \
replacementchar=? } margin=4" \
	    $testcases($test,$fontname) $testcases($test,$encoding)]
	set table [PDF_add_table_cell $p $table $col $row \
		$testcases($test,$text) $optlist]
	incr col

	# Column 4: text with base font and fallback fonts
	set optlist [format "fittextline={fontname=%s encoding=%s \
fontsize=11 fallbackfonts={%s}} margin=4" \
	     $testcases($test,$fontname) \
	     $testcases($test,$encoding) \
	     $testcases($test,$fallbackoptions)]
	set table [PDF_add_table_cell $p $table $col $row \
	       $testcases($test,$text) $optlist]
    }

    # Place the table
    set optlist "header=1 fill={{area=rowodd \
fillcolor={gray 0.9}}} stroke={{line=other}} "
    set result [PDF_fit_table $p $table $llx $lly $urx $ury $optlist]

    if {$result == "_error"} {
	puts stderr [format "Couldn't place table: %s\n" [PDF_get_errmsg $p]]
	exit
    }

    PDF_end_page_ext $p ""
    PDF_end_document $p ""

} result] } {
    puts stderr "$result"
}

# delete the PDFlib object
PDF_delete $p

