#!/bin/sh
# $Id: starter_path.tcl,v 1.1.2.2 2010/12/08 12:04:36 kurt Exp $
#
# Hide the exec to Tcl but not to the shell by appending a backslash\
exec tclsh "$0" ${1+"$@"}

# Starter sample for path objects:
# Create some basic examples of path object construction and use
#
# Required software: PDFlib/PDFlib+PDI/PPS 8
# Required data: none
#

# The lappend line is unnecessary if PDFlib has been installed
# in the Tcl package directory
set auto_path [linsert $auto_path 0 .libs .]

package require pdflib 8.0

set outfilename "starter_path.pdf";

# Dummy text 
set text "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. "

set p [PDF_new]

if { [catch {

    PDF_set_parameter $p "errorpolicy" "exception"

    PDF_begin_document $p $outfilename ""

    PDF_set_info $p "Creator" "PDFlib starter sample"
    PDF_set_info $p "Title" "starter_path"

    # Start an A4 page 
    PDF_begin_page_ext $p 0 0 "width=a4.width height=a4.height"

    # Construct a path object for an arrow shape 

    set path -1

    # The tip of the arrow gets rounded corners 
    set path [PDF_add_path_point $p $path 200.0  25.0 "move" "round=10"]
    set path [PDF_add_path_point $p $path 200.0  75.0 "line" ""]
    # assign a name to the arrow's tip 
    set path [PDF_add_path_point $p $path 300.0   0.0 "line" "name=tip"]
    set path [PDF_add_path_point $p $path 200.0 -75.0 "line" ""]
    set path [PDF_add_path_point $p $path 200.0 -25.0 "line" ""]

    # Start a new subpath for the straight base of the arrow 
    set path [PDF_add_path_point $p $path 200.0 -25.0 "move" ""]
    set path [PDF_add_path_point $p $path   0.0 -25.0 "line" ""]

    # The center of the base can serve as a named attachment point 
    set path [PDF_add_path_point $p $path   0.0   0.0 "line" "name=base"]
    set path [PDF_add_path_point $p $path   0.0  25.0 "line" ""]
    set path [PDF_add_path_point $p $path 200.0  25.0 "line" ""]

    set x 100.0
    set y 850.0


    # ----------------------------------------
    # Place arrow in its original direction
    # ----------------------------------------
    #
    set y [expr $y - 100.0]
    PDF_draw_path $p $path $x $y "stroke linewidth=3 fill fillcolor=Turquoise linecap=projecting attachmentpoint=base "


    # ----------------------------------------
    # Scale down arrow and align it to north east
    # ----------------------------------------
    #
    set y [expr $y - 200.0]
    PDF_draw_path $p $path $x $y "stroke linewidth=3 fill fillcolor=Turquoise linecap=projecting attachmentpoint=base scale=0.5 align={1 1}"


    # ----------------------------------------
    # Scale to 50%, use the arrow tip as attachment point,
    # and align the arrow to the left
    # ----------------------------------------
    #
    set y [expr $y - 100.0]
    PDF_draw_path $p $path $x $y "stroke linewidth=3 fill fillcolor=Turquoise linecap=projecting attachmentpoint=tip scale=0.5 align={-1 0}"


    # ----------------------------------------
    # Place text on the path; round all corners to
    # allow smoother text at the corners
    # ----------------------------------------
    #
    set y [expr $y - 100.0]
    set optlist [format "textpath={path=%d round=10} position={center bottom} fontname=Helvetica encoding=winansi fontsize=8" $path]
    PDF_fit_textline $p $text $x $y $optlist


    # ----------------------------------------
    # Use the path as clipping path for a Textflow
    # ----------------------------------------
    #
    set y [expr $y - 300.0]

    # Feed the text to the Textflow object
    set tf [PDF_add_textflow $p -1 $text "fontname=Helvetica fontsize=10 encoding=winansi charref alignment=justify"]
    # Use text twice to fill the arrow
    set tf [PDF_add_textflow $p $tf $text "fontname=Helvetica fontsize=10 encoding=winansi charref alignment=justify"]

    # Attach the path's reference point to the middle left (0% 50%)
    # of the fitbox and wrap the text inside the path (inversefill)
    #
    set optlist [format "wrap={inversefill paths={{path=%d refpoint={0%% 50%%} scale=1.5 }}}" $path]
    set result [PDF_fit_textflow $p $tf $x $y [expr $x+450] [expr $y+225] $optlist]

    if {$result == "_stop"} {
        # In this example we don't care about overflow text
    }
    PDF_delete_textflow $p $tf


    # ----------------------------------------
    # Query information about the path object
    # ----------------------------------------
    #
    set n [PDF_info_path $p $path "numpoints" ""]


    PDF_delete_path $p $path
    PDF_end_page_ext $p ""
    PDF_end_document $p ""

} result] } {
    puts stderr "$result"
}

# delete the PDFlib object
PDF_delete $p

