#!/bin/sh
# $Id: starter_block.tcl,v 1.8 2009/09/16 16:20:39 rjs Exp $
#
# Hide the exec to Tcl but not to the shell by appending a backslash\
exec tclsh "$0" ${1+"$@"}

# PDF portfolio starter:
# Package multiple PDF and other documents into a PDF portfolio
# The generated PDF portfolio requires Acrobat 9 for proper
# viewing. The documents in the Portfolio will be assigned predefined
# and custom metadata fields; for the custom fields a schema description
# is created.
#
# Acrobat 8 will only display a "PDF package" with a flat list of documents
# without any folder structure.
#
# Required software: PDFlib/PDFlib+PDI/PPS 8
# Required data: PDF and other input documents

# The linsert line is unnecessary if PDFlib has been installed
# in the Tcl package directory
set auto_path [linsert $auto_path 0 .libs .]

package require pdflib 8.0

# This is where the data files are. Adjust as necessary.
set searchpath "../data"
set optlist ""

# Structure portfolio
set filename 0
set description 1
set status 2
set id 3

# The documents for the Portfolio along with description and metadata
set pf(0,0) "TIR_____.AFM"
set pf(0,1) "Metrics for Times-Roman"
set pf(0,2) "internal"
set pf(0,3) 200

set pf(1,0) "nesrin.jpg"
set pf(1,1) "Zabrisky point"
set pf(1,2) "archived"
set pf(1,3) 300

set pf(2,0) "PDFlib-real-world.pdf"
set pf(2,1) "PDFlib in the real world"
set pf(2,2) "published"
set pf(2,3) 100

set pf(3,0) "PDFlib-datasheet.pdf"
set pf(3,1) "Generate PDF on the fly"
set pf(3,2) "published"
set pf(3,3) 101

set pf(4,0) "TET-datasheet.pdf"
set pf(4,1) "Extract text and images from PDF"
set pf(4,2) "published"
set pf(4,3) 102

set pf(5,0) "PLOP-datasheet.pdf"
set pf(5,1) "PDF Linearization, Optimization, Protection"
set pf(5,2) "published"
set pf(5,3) 103

set pf(6,0) "pCOS-datasheet.pdf"
set pf(6,1) "PDF Information Retrieval Tool"
set pf(6,2) "published"
set pf(6,3) 104

set n_files  7

set p [PDF_new]

if { [catch {
    PDF_set_parameter $p "SearchPath" $searchpath

    # This means we must check return values of load_font() etc.
    PDF_set_parameter $p "errorpolicy" "return"

    if {[PDF_begin_document $p "starter_portfolio.pdf" "compatibility=1.7ext3"] == -1} {
	puts stderr [format "Error: %s\n" [PDF_get_errmsg $p]]
	PDF_delete $p
	exit
    }

    PDF_set_info $p "Creator" "PDFlib starter sample"
    PDF_set_info $p "Title" "starter_portfolio"

    # Insert all files for the root folder along with their description
    # and the following custom fields:
    # status   string describing the document status
    # id       numerical identifier, prefixed with "PHX"
    for {set i 0} {$i < 2} {incr i} {
        set optlist [format "description={%s} fieldlist={ {key=status value=%s} {key=id value=%d prefix=PHX type=text} }" $pf($i,$description) $pf($i,$status) $pf($i,$id)]

        # -1 means root folder
        PDF_add_portfolio_file $p -1 $pf($i,$filename) $optlist
    }

    # Create the "datasheets" folder in the root folder
    set folder [PDF_add_portfolio_folder $p -1 "datasheets" ""]

    # Insert documents in the "datasheets" folder along with
    # description and custom fields
    for {set i 2} {$i < $n_files} {incr i} {
        set optlist [format \
        	"description={%s} fieldlist={ {key=status value=%s} {key=id value=%d prefix=PHX type=text} }" $pf($i,$description) $pf($i,$status) $pf($i,$id)]
    
        # Add the file to the "datasheets" folder
        PDF_add_portfolio_file $p $folder $pf($i,$filename) $optlist
    }
    
    # Create a single-page document as cover sheet
    PDF_begin_page_ext $p 0 0 "width=a4.width height=a4.height"
    
    set font [PDF_load_font $p "Helvetica" "winansi" ""]
    if {$font == -1} {
	puts stderr [format "Error: %s\n" [PDF_get_errmsg $p]]
	PDF_delete $p
	exit
    }

    PDF_setfont $p $font 24
    PDF_fit_textline $p "Welcome to the PDFlib Portfolio sample!" 50 700 ""

    PDF_end_page_ext $p ""
    
    # Set options for Portfolio display
    set optlist "portfolio={initialview=detail "
    
    # Add schema definition for Portfolio metadata
    append optlist "schema={ "
    # Some predefined fields are included here to make them visible.
    append optlist "{order=1 label=Name key=_filename visible editable} "
    append optlist "{order=2 label=Description key=_description visible} "
    append optlist "{order=3 label=Size key=_size visible} "
    append optlist "{order=4 label={Last edited} key=_moddate visible} "
    
    # User-defined fields
    append optlist "{order=5 label=Status key=status type=text editable} "
    append optlist "{order=6 label=ID key=id type=text editable} "
    
    append optlist "}}"

    PDF_end_document $p $optlist

} result] } {
    puts stderr "$result"
}

# delete the PDFlib object
PDF_delete $p

