#!/bin/sh
# $Id: starter_block.tcl,v 1.8 2009/09/16 16:20:39 rjs Exp $
#
# Hide the exec to Tcl but not to the shell by appending a backslash\
exec tclsh "$0" ${1+"$@"}

# Starter sample for text shaping features
# Demonstrate text shaping for Arabic, Hebrew, Devanagari, and Thai scripts
# Right-to-left text is reordered according to the Bidi algorithm.
#
# Required software: PDFlib/PDFlib+PDI/PPS 8
# Required data: suitable fonts for the scripts

# The linsert line is unnecessary if PDFlib has been installed
# in the Tcl package directory
set auto_path [linsert $auto_path 0 .libs .]

package require pdflib 8.0

# This is where the data files are. Adjust as necessary.
set searchpath "../data"
set outfile "starter_shaping.pdf"

set llx 50.0
set lly 50.0
set urx 800.0
set ury 550.0

set header(0) "Language"
set header(1) "Raw input"
set header(2) "Reordered and shaped output"

set MAXROW 16
set MAXCOL 3

# Structure shaping
set fontname 0
set ioptlist 1
set textflow 2
set language 3
set text 4

# Dummys to compensate for header row and +/-1 indexing i
set shapingsamples(0,0) ""
set shapingsamples(0,1) ""
set shapingsamples(0,2) 0
set shapingsamples(0,3) ""
set shapingsamples(0,4) ""

set shapingsamples(1,0) ""
set shapingsamples(1,1) ""
set shapingsamples(1,1) 0
set shapingsamples(1,3) ""
set shapingsamples(1,4) ""

# -------------------------- Arabic -------------------------- 
set shapingsamples(2,0) "ScheherazadeRegOT"
set shapingsamples(2,1) "shaping script=arab"
set shapingsamples(2,2) 0
set shapingsamples(2,3) "Arabic"
set shapingsamples(2,4) "&#x0627;&#x0644;&#x0639;&#x064E;&#x0631;&#x064E;&#x0628;&#x0650;&#x064A;&#x0629;"

set shapingsamples(3,0) "ScheherazadeRegOT"
set shapingsamples(3,1) "shaping script=arab"
set shapingsamples(3,2) 0
set shapingsamples(3,3) "Arabic"
set shapingsamples(3,4) "&#x0645;&#x0631;&#x062D;&#x0628;&#x0627;! (Hello)"


set shapingsamples(4,0) "ScheherazadeRegOT"
set shapingsamples(4,1) "shaping script=arab"
set shapingsamples(4,2) 0
set shapingsamples(4,3) "Arabic"
set shapingsamples(4,4) "&#xFEFF;&#x0627;&#x0644;&#x0645;&#x0627;&#x062F;&#x0629;&#x0020;&#x0031;&#x0020;&#x064A;&#x0648;&#x0644;&#x062F;&#x0020;&#x062C;&#x0645;&#x064A;&#x0639;&#x0020;&#x0627;&#x0644;&#x0646;&#x0627;&#x0633;&#x0020;&#x0623;&#x062D;&#x0631;&#x0627;&#x0631;&#x064B;&#x0627;&#x0020;&#x0645;&#x062A;&#x0633;&#x0627;&#x0648;&#x064A;&#x0646;&#x0020;&#x0641;&#x064A;&#x0020;&#x0627;&#x0644;&#x0643;&#x0631;&#x0627;&#x0645;&#x0629;&#x0020;&#x0648;&#x0627;&#x0644;&#x062D;&#x0642;&#x0648;&#x0642;&#x002E;&#x0020;"

set shapingsamples(5,0) "ScheherazadeRegOT"
set shapingsamples(5,1) "shaping script=arab"
set shapingsamples(5,2) 0
set shapingsamples(5,3) "Arabic"
set shapingsamples(5,4) "&#x0648;&#x0642;&#x062F;&#x0020;&#x0648;&#x0647;&#x0628;&#x0648;&#x0627;&#x0020;&#x0639;&#x0642;&#x0644;&#x0627;&#x064B;&#x0020;&#x0648;&#x0636;&#x0645;&#x064A;&#x0631;&#x064B;&#x0627;&#x0020;&#x0648;&#x0639;&#x0644;&#x064A;&#x0647;&#x0645;&#x0020;&#x0623;&#x0646;&#x0020;&#x064A;&#x0639;&#x0627;&#x0645;&#x0644;&#x0020;&#x0628;&#x0639;&#x0636;&#x0647;&#x0645;&#x0020;&#x0628;&#x0639;&#x0636;&#x064B;&#x0627;&#x0020;&#x0628;&#x0631;&#x0648;&#x062D;&#x0020;&#x0627;&#x0644;&#x0625;&#x062E;&#x0627;&#x0621;&#x002E;"

# -------------------------- Hebrew -------------------------- 
set shapingsamples(6,0) "SILEOT"
set shapingsamples(6,1) "shaping script=hebr"
set shapingsamples(6,2) 0
set shapingsamples(6,3) "Hebrew"
set shapingsamples(6,4) "&#x05E2;&#x05B4;&#x05D1;&#x05B0;&#x05E8;&#x05B4;&#x05D9;&#x05EA;"


set shapingsamples(7,0) "SILEOT"
set shapingsamples(7,1) "shaping script=hebr"
set shapingsamples(7,2) 0
set shapingsamples(7,3) "Hebrew"
set shapingsamples(7,4) "&#x05E1;&#x05E2;&#x05D9;&#x05E3;&#x0020;&#x05D0;&#x002E;&#x0020;&#x05DB;&#x05DC;&#x0020;&#x05D1;&#x05E0;&#x05D9;&#x0020;&#x05D0;&#x05D3;&#x05DD;&#x0020;&#x05E0;&#x05D5;&#x05DC;&#x05D3;&#x05D5;&#x0020;&#x05D1;&#x05E0;&#x05D9;&#x0020;&#x05D7;&#x05D5;&#x05E8;&#x05D9;&#x05DF;&#x0020;&#x05D5;&#x05E9;&#x05D5;&#x05D5;&#x05D9;&#x05DD;&#x0020;&#x05D1;&#x05E2;&#x05E8;&#x05DB;&#x05DD;&#x0020;&#x05D5;&#x05D1;&#x05D6;&#x05DB;&#x05D5;&#x05D9;&#x05D5;&#x05EA;&#x05D9;&#x05D4;&#x05DD;&#x002E;&#x0020;"

set shapingsamples(8,0) "SILEOT"
set shapingsamples(8,1) "shaping script=hebr"
set shapingsamples(8,2) 0
set shapingsamples(8,3) "Hebrew"
set shapingsamples(8,4) "&#x05DB;&#x05D5;&#x05DC;&#x05DD;&#x0020;&#x05D7;&#x05D5;&#x05E0;&#x05E0;&#x05D5;&#x0020;&#x05D1;&#x05EA;&#x05D1;&#x05D5;&#x05E0;&#x05D4;&#x0020;&#x05D5;&#x05D1;&#x05DE;&#x05E6;&#x05E4;&#x05D5;&#x05DF;&#x002C;&#x0020;"


set shapingsamples(9,0) "SILEOT"
set shapingsamples(9,1) "shaping script=hebr"
set shapingsamples(9,2) 0
set shapingsamples(9,3) "Hebrew"
set shapingsamples(9,4) "&#x05DC;&#x05E4;&#x05D9;&#x05DB;&#x05DA;&#x0020;&#x05D7;&#x05D5;&#x05D1;&#x05D4;&#x0020;&#x05E2;&#x05DC;&#x05D9;&#x05D4;&#x05DD;&#x0020;&#x05DC;&#x05E0;&#x05D4;&#x05D5;&#x05D2;&#x0020;&#x05D0;&#x05D9;&#x05E9;&#x0020;&#x05D1;&#x05E8;&#x05E2;&#x05D4;&#x05D5;&#x0020;&#x05D1;&#x05E8;&#x05D5;&#x05D7;&#x0020;&#x05E9;&#x05DC;&#x0020;&#x05D0;&#x05D7;&#x05D5;&#x05D4;&#x002E;" 

# -------------------------- Hindi -------------------------- 
set shapingsamples(10,0) "raghu8"
set shapingsamples(10,1) "shaping script=deva advancedlinebreak"
set shapingsamples(10,2) 1
set shapingsamples(10,3) "Hindi"
set shapingsamples(10,4) "&#x0939;&#x093F;&#x0928;&#x094D;&#x0926;&#x0940;"


set shapingsamples(11,0) "raghu8"
set shapingsamples(11,1) "shaping script=deva advancedlinebreak"
set shapingsamples(11,2) 1
set shapingsamples(11,3) "Hindi"
set shapingsamples(11,4) "&#x0905;&#x0928;&#x0941;&#x091A;&#x094D;&#x091B;&#x0947;&#x0926;&#x0020;&#x0967;&#x002E;&#x0020;&#x0938;&#x092D;&#x0940;&#x0020;&#x092E;&#x0928;&#x0941;&#x0937;&#x094D;&#x092F;&#x094B;&#x0902;&#x0020;&#x0915;&#x094B;&#x0020;&#x0917;&#x094C;&#x0930;&#x0935;&#x0020;&#x0914;&#x0930;&#x0020;&#x0905;&#x0927;&#x093F;&#x0915;&#x093E;&#x0930;&#x094B;&#x0902;&#x0020;&#x0915;&#x0947;&#x0020;&#x092E;&#x093E;&#x092E;&#x0932;&#x0947;&#x0020;&#x092E;&#x0947;&#x0902;&#x0020;&#x091C;&#x0928;&#x094D;&#x092E;&#x091C;&#x093E;&#x0924;&#x0020;&#x0938;&#x094D;&#x0935;&#x0924;&#x0928;&#x094D;&#x0924;&#x094D;&#x0930;&#x0924;&#x093E;&#x0020;&#x0914;&#x0930;&#x0020;&#x0938;&#x092E;&#x093E;&#x0928;&#x0924;&#x093E;&#x0020;&#x092A;&#x094D;&#x0930;&#x093E;&#x092A;&#x094D;&#x0924;&#x0020;&#x0939;&#x0948;&#x0020;&#x0964;&#x0020;&#x0909;&#x0928;&#x094D;&#x0939;&#x0947;&#x0902;&#x0020;&#x092C;&#x0941;&#x0926;&#x094D;&#x0918;&#x093F;&#x0020;&#x0914;&#x0930;&#x0020;&#x0905;&#x0928;&#x094D;&#x0924;&#x0930;&#x093E;&#x0924;&#x094D;&#x092E;&#x093E;&#x0020;&#x0915;&#x0940;&#x0020;&#x0926;&#x0947;&#x0928;&#x0020;&#x092A;&#x094D;&#x0930;&#x093E;&#x092A;&#x094D;&#x0924;&#x0020;&#x0939;&#x0948;&#x0020;&#x0914;&#x0930;&#x0020;&#x092A;&#x0930;&#x0938;&#x094D;&#x092A;&#x0930;&#x0020;&#x0909;&#x0928;&#x094D;&#x0939;&#x0947;&#x0902;&#x0020;&#x092D;&#x093E;&#x0908;&#x091A;&#x093E;&#x0930;&#x0947;&#x0020;&#x0915;&#x0947;&#x0020;&#x092D;&#x093E;&#x0935;&#x0020;&#x0938;&#x0947;&#x0020;&#x092C;&#x0930;&#x094D;&#x0924;&#x093E;&#x0935;&#x0020;&#x0915;&#x0930;&#x0928;&#x093E;&#x0020;&#x091A;&#x093E;&#x0939;&#x093F;&#x090F;&#x0020;&#x0964;"

# -------------------------- Sanskrit -------------------------- 
set shapingsamples(12,0) "raghu8"
set shapingsamples(12,1) "shaping script=deva advancedlinebreak"
set shapingsamples(12,2) 1
set shapingsamples(12,3) "Sanskrit"
set shapingsamples(12,4) "&#x0938;&#x0902;&#x0938;&#x094D;&#x0915;&#x0943;&#x0924;&#x092E;&#x094D;"

set shapingsamples(13,0) "raghu8"
set shapingsamples(13,1) "shaping script=deva advancedlinebreak"
set shapingsamples(13,2) 1
set shapingsamples(13,3) "Sanskrit"
set shapingsamples(13,4) "&#x0905;&#x0928;&#x0941;&#x091A;&#x094D;&#x091B;&#x0947;&#x0926;&#x003A;&#x0020;&#x0031;&#x0020;&#x0938;&#x0930;&#x094D;&#x0935;&#x0947;&#x0020;&#x092E;&#x093E;&#x0928;&#x0935;&#x093E;&#x003A;&#x0020;&#x0938;&#x094D;&#x0935;&#x0924;&#x0928;&#x094D;&#x0924;&#x094D;&#x0930;&#x093E;&#x003A;&#x0020;&#x0938;&#x092E;&#x0941;&#x0924;&#x094D;&#x092A;&#x0928;&#x094D;&#x0928;&#x093E;&#x003A;&#x0020;&#x0935;&#x0930;&#x094D;&#x0924;&#x0928;&#x094D;&#x0924;&#x0947;&#x0020;&#x0905;&#x092A;&#x093F;&#x0020;&#x091A;&#x002C;&#x0020;&#x0917;&#x094C;&#x0930;&#x0935;&#x0926;&#x0943;&#x0936;&#x093E;&#x0020;&#x0905;&#x0927;&#x093F;&#x0915;&#x093E;&#x0930;&#x0926;&#x0943;&#x0936;&#x093E;&#x0020;&#x091A;&#x0020;&#x0938;&#x092E;&#x093E;&#x0928;&#x093E;&#x003A;&#x0020;&#x090F;&#x0935;&#x0020;&#x0935;&#x0930;&#x094D;&#x0924;&#x0928;&#x094D;&#x0924;&#x0947;&#x0964;&#x0020;&#x090F;&#x0924;&#x0947;&#x0020;&#x0938;&#x0930;&#x094D;&#x0935;&#x0947;&#x0020;&#x091A;&#x0947;&#x0924;&#x0928;&#x093E;&#x002D;&#x0924;&#x0930;&#x094D;&#x0915;&#x002D;&#x0936;&#x0915;&#x094D;&#x0924;&#x093F;&#x092D;&#x094D;&#x092F;&#x093E;&#x0902;&#x0020;&#x0938;&#x0941;&#x0938;&#x092E;&#x094D;&#x092A;&#x0928;&#x094D;&#x0928;&#x093E;&#x003A;&#x0020;&#x0938;&#x0928;&#x094D;&#x0924;&#x093F;&#x0964;&#x0020;&#x0905;&#x092A;&#x093F;&#x0020;&#x091A;&#x002C;&#x0020;&#x0938;&#x0930;&#x094D;&#x0935;&#x0947;&#x093D;&#x092A;&#x093F;&#x0020;&#x092C;&#x0928;&#x094D;&#x0927;&#x0941;&#x0924;&#x094D;&#x0935;&#x002D;&#x092D;&#x093E;&#x0935;&#x0928;&#x092F;&#x093E;&#x0020;&#x092A;&#x0930;&#x0938;&#x094D;&#x092A;&#x0930;&#x0902;&#x0020;&#x0935;&#x094D;&#x092F;&#x0935;&#x0939;&#x0930;&#x0928;&#x094D;&#x0924;&#x0941;&#x0964;"

# -------------------------- Thai -------------------------- 
set shapingsamples(14,0) "Norasi"
set shapingsamples(14,1) "shaping script=thai advancedlinebreak"
set shapingsamples(14,2) 1
set shapingsamples(14,3) "Thai"
set shapingsamples(14,4) "&#x0E44;&#x0E17;&#x0E22;"


set shapingsamples(15,0) "Norasi"
set shapingsamples(15,1) "shaping script=thai advancedlinebreak"
set shapingsamples(15,2) 1
set shapingsamples(15,3) "Thai"
set shapingsamples(15,4) "&#x0E02;&#x0E49;&#x0E2D;&#x0020;&#x0031;&#x0020;&#x0E21;&#x0E19;&#x0E38;&#x0E29;&#x0E22;&#x0E4C;&#x0E17;&#x0E31;&#x0E49;&#x0E07;&#x0E2B;&#x0E25;&#x0E32;&#x0E22;&#x0E40;&#x0E01;&#x0E34;&#x0E14;&#x0E21;&#x0E32;&#x0E21;&#x0E35;&#x0E2D;&#x0E34;&#x0E2A;&#x0E23;&#x0E30;&#x0E41;&#x0E25;&#x0E30;&#x0E40;&#x0E2A;&#x0E21;&#x0E2D;&#x0E20;&#x0E32;&#x0E04;&#x0E01;&#x0E31;&#x0E19;&#x0E43;&#x0E19;&#x0E40;&#x0E01;&#x0E35;&#x0E22;&#x0E23;&#x0E15;&#x0E34;&#x0E28;&#x0E31;&#x0E01;&#x0E14;&#x005B;&#x0E40;&#x0E01;&#x0E35;&#x0E22;&#x0E23;&#x0E15;&#x0E34;&#x0E28;&#x0E31;&#x0E01;&#x0E14;&#x0E34;&#x0E4C;&#x005D;&#x0E41;&#x0E25;&#x0E30;&#x0E2A;&#x0E34;&#x0E17;&#x0E18;&#x0E34;&#x0020;&#x0E15;&#x0E48;&#x0E32;&#x0E07;&#x0E21;&#x0E35;&#x0E40;&#x0E2B;&#x0E15;&#x0E38;&#x0E1C;&#x0E25;&#x0E41;&#x0E25;&#x0E30;&#x0E21;&#x0E42;&#x0E19;&#x0E18;&#x0E23;&#x0E23;&#x0E21;&#x0020;&#x0E41;&#x0E25;&#x0E30;&#x0E04;&#x0E27;&#x0E23;&#x0E1B;&#x0E0F;&#x0E34;&#x0E1A;&#x0E31;&#x0E15;&#x0E34;&#x0E15;&#x0E48;&#x0E2D;&#x0E01;&#x0E31;&#x0E19;&#x0E14;&#x0E49;&#x0E27;&#x0E22;&#x0E40;&#x0E08;&#x0E15;&#x0E19;&#x0E32;&#x0E23;&#x0E21;&#x0E13;&#x0E4C;&#x0E41;&#x0E2B;&#x0E48;&#x0E07;&#x0E20;&#x0E23;&#x0E32;&#x0E14;&#x0E23;&#x0E20;&#x0E32;&#x0E1E;"


set p [PDF_new]

if { [catch {
    PDF_set_parameter $p "SearchPath" $searchpath
    PDF_set_parameter $p "charref" "true"

    # This means that formatting and other errors will raise an
    # exception. This simplifies our sample code, but is not
    # recommended for production code.
    PDF_set_parameter $p "errorpolicy" "exception"

    # Set an output path according to the name of the topic
    if {[PDF_begin_document $p $outfile ""] == -1} {
	puts stderr [format "Error: %s\n" [PDF_get_errmsg $p]]
	PDF_delete $p
	exit
    }

    PDF_set_info $p "Creator" "PDFlib starter sample"
    PDF_set_info $p "Title" "starter_shaping"

    set table -1

    # Create table header
    set row 1
    for {set col 1} {$col <= $MAXCOL} {incr col} {
	if {$col == 1} {
	    set optlist \
	       "fittextline={fontname=Helvetica-Bold encoding=winansi fontsize=14} colwidth=10%"
	} else {
	    set optlist \
	       "fittextline={fontname=Helvetica-Bold encoding=winansi fontsize=14} colwidth=45%"
	}
        set table [PDF_add_table_cell $p $table $col 1 $header([expr $col-1]) $optlist]
    }

    # Create shaping samples
    for {set row 2} {$row < $MAXROW} {incr row} {
        set col 1

        # Column 1: language name
        set optlist \
            "fittextline={fontname=Helvetica encoding=unicode fontsize=12}"
        set table [PDF_add_table_cell $p $table $col $row \
                    $shapingsamples($row,$language) $optlist]
	incr col

        # Column 2: raw text
        set optlist [format \
            "fontname={%s} encoding=unicode fontsize=13 leading=150%% alignment=left" \
	    $shapingsamples($row,$fontname)]
        set tf [PDF_create_textflow $p $shapingsamples($row,$text) $optlist]
        set optlist [format \
            "margin=4 fittextflow={verticalalign=top} textflow=%d" $tf]
        set table [PDF_add_table_cell $p $table $col $row "" $optlist]
	incr col

        # Column 3: shaped and reordered text (Textline or Textflow)
        if {$shapingsamples($row,$textflow)} {
            set optlist [format \
               "fontname={%s} encoding=unicode fontsize=13 %s leading=150%% alignment=left" \
	       $shapingsamples($row,$fontname) $shapingsamples($row,$ioptlist)]
            set tf [PDF_create_textflow $p $shapingsamples($row,$text) $optlist]
            set optlist [format \
                "margin=4 fittextflow={verticalalign=top} textflow=%d" $tf]
            set table [PDF_add_table_cell $p $table $col $row "" $optlist]
	    incr col
        } else {
            set optlist [format \
               "fittextline={fontname={%s} encoding=unicode fontsize=13 %s}" \
		   $shapingsamples($row,$fontname) $shapingsamples($row,$ioptlist)]
            set table [PDF_add_table_cell $p $table $col $row \
                                        $shapingsamples($row,$text) $optlist]
	    incr col
        }
    }

    # ---------- Place the table on one or more pages ----------
    #
    # Loop until all of the table is placed; create new pages
    # as long as more table instances need to be placed.
    while {1} {
        PDF_begin_page_ext $p 0 0 "width=a4.height height=a4.width"

        # Shade every other row; draw lines for all table cells.
        set optlist "header=1 fill={{area=rowodd fillcolor={gray 0.9}}} stroke={{line=other}} "

        # Place the table instance
        set result [PDF_fit_table $p $table $llx $lly $urx $ury $optlist]

        if {$result == "_error"} {
	    puts stderr [format "Couldn't place table: %s\n" [PDF_get_errmsg $p]]
	    PDF_delete $p
	    exit
        }

        PDF_end_page_ext $p ""
	
	if {$result != "_boxfull"} {
	    break
	}
    }

    PDF_end_document $p ""
} result] } {
    puts stderr "$result"
}

# delete the PDFlib
