/* $Id: imageServlet.java,v 1.11 2004/05/17 12:47:19 rp Exp $
 *
 * PDFlib client: image example in JavaServlet
 */

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

public class ImageServlet extends HttpServlet {
    private static final long serialVersionUID = -2149485062043833504L;

    public void service(HttpServletRequest request, HttpServletResponse response)
            throws ServletException {
        pdflib p = null;
        String imagefile = "nesrin.jpg";

        /* This is where font/image/PDF input files live. Adjust as necessary. */
        ServletContext context = getServletContext();
        String searchpath = context.getRealPath("/WEB-INF/data");

        /*
         * Catch problems that application data cannot be accessed.
         */
        if (searchpath == null) {
            throw new ServletException(
                    "Error: Unable to access application data (WAR file not unpacked?)");
        }

        try {
            p = new pdflib();

            // Generate a PDF in memory; insert a file name to create PDF on
            // disk
            if (p.begin_document("", "") == -1) {
                throw new ServletException("Error: " + p.get_apiname() + ": "
                        + p.get_errmsg());
            }

            p.set_parameter("SearchPath", searchpath);

            p.set_info("Creator", "imageServlet.java");
            p.set_info("Author", "Rainer Ploeckl");
            p.set_info("Title", "image sample (Java/Servlet)");

            if (request.getParameter("image") != null) {
                imagefile = request.getParameter("image");
            }

            int image = p.load_image("auto", imagefile, "");

            if (image == -1) {
                throw new ServletException("Error: " + p.get_apiname() + ": "
                        + p.get_errmsg());
            }

            /* dummy page size, will be adjusted by PDF_fit_image() */
            p.begin_page_ext(10, 10, "");
            p.fit_image(image, 0.0, 0.0, "adjustpage");
            p.close_image(image);
            p.end_page_ext("");

            p.end_document("");

            byte[] buf = p.get_buffer();

            response.setContentType("application/pdf");
            response.setContentLength(buf.length);
            response.setHeader("Content-Disposition",
                    "inline; filename=image.pdf");

            ServletOutputStream output = response.getOutputStream();
            output.write(buf);
            output.close();
        }
        catch (PDFlibException e) {
            throw new ServletException("PDFlib exception occurred in "
                    + getClass().getName(), e);
        }
        catch (Exception e) {
            throw new ServletException("Exception occurred in "
                    + getClass().getName(), e);
        }
        finally {
            if (p != null) {
                p.delete(); /* delete the PDFlib object */
            }
        }
    }
}
