/* $Id: starter_3d.java,v 1.3.2.2 2011/06/06 11:32:10 rjs Exp $
 * 3D Starter:
 * Load a 3D model and create a 3D annotation from it.
 *
 * Define a 3D view and load some 3D data with the view defined. Then create
 * an annotation containing the loaded 3D data with the defined 3D view as the
 * initial view.
 *
 * Required software: PDFlib/PDFlib+PDI/PPS 8.0.3
 * Required data: PRC data file
 */
import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

public class starter_3d {
    public static void main(String argv[]) {
        /* This is where the data files are. Adjust if necessary. */
        String searchpath = "../data";
        String outfile = "starter_3d.pdf";

        pdflib p = null;


        String optlist;
        int font, view, data;

        try {
            p = new pdflib();

            p.set_parameter("SearchPath", searchpath);

            /* This means we must check return values of load_font() etc. */
            p.set_parameter("errorpolicy", "return");

            /* Start the document */
            if (p.begin_document(outfile, "compatibility=1.7ext3") == -1)
                throw new Exception("Error: " + p.get_errmsg());

            p.set_info("Creator", "PDFlib starter sample");
            p.set_info("Title", "starter_3d");

            font = p.load_font("Helvetica", "winansi", "");
            if (font == -1)
                throw new Exception("Error: " + p.get_errmsg());

            p.begin_page_ext(0, 0, "width=a4.width height=a4.height");

            /* Define a 3D view which shows the model from the top */
            optlist ="type=PRC name=FirstView background={fillcolor=Lavender} "+
		"camera2world={-1 0 0 0 1 0 0 0 -1 0.5 0 300}";
            if ((view = p.create_3dview("First view", optlist)) == -1)
                throw new Exception("Error: " + p.get_errmsg());

            /* Load some 3D data with the view defined above */
            if ((data = p.load_3ddata("riemann.prc", "type=PRC views={" + view + "}")) == -1)
                throw new Exception("Error: " + p.get_errmsg());

            /*
             * Create an annotation containing the loaded 3D data with the
             * defined 3D view as the initial view
             */
            optlist = "name=annot usercoordinates contents=PRC 3Ddata= "
                    + data + " 3Dactivate={enable=open} 3Dinitialview="
                    + view;
            p.create_annotation(116, 200, 447, 580, "3D", optlist);

            p.end_page_ext("");

            p.end_document("");

        }
        catch (PDFlibException e) {
            System.err.print("PDFlib exception occurred:\n");
            System.err.print("[" + e.get_errnum() + "] " + e.get_apiname()
                    + ": " + e.get_errmsg() + "\n");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        finally {
            if (p != null) {
                p.delete();
            }
        }
    }
}
