/* $Id: starter_block.java,v 1.6 2009/09/10 13:13:11 stm Exp $
 *
 * Block starter:
 * Import a PDF page containing blocks and fill text and image
 * blocks with some data. For each addressee of the simulated
 * mailing a separate page with personalized information is
 * generated.
 * A real-world application would of course fill the blocks with data
 * retrieved from some external data source.
 *
 * Required software: PPS 8 or above
 * Required data: input PDF, image
 */

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

public class starter_block {
    public static void main(String argv[]) {

        /* This is where the data files are. Adjust as necessary. */
        String searchpath = "../data";
        String outfile = "starter_block.pdf";
        String infile = "block_template.pdf";
        String imagefile = "new.jpg";

        pdflib p = null;
        int i, j, inpage, indoc, image;
        String optlist, buf;

        /* Names of the person-related blocks contained on the imported page */
        String addressblocks[] = { "name", "street", "city" };

        /* Data related to various persons used for personalization */
        String persons[][] = {
            { "Mr Maurizio Moroni", "Strada Provinciale 124", "Reggio Emilia" },
            { "Ms Dominique Perrier", "25, rue Lauriston", "Paris" },
            { "Mr Liu Wong", "55 Grizzly Peak Rd.", "Butte" } };

        /* Static text simulates database-driven variable contents */
        final String intro = "Dear";
        final String goodbye = "Yours sincerely,\nVictor Kraxi";
        final String announcement = 
            "Our <fillcolor=red>BEST PRICE OFFER<fillcolor=black> includes today:"
            + "\n\n"
            + "Long Distance Glider\nWith this paper rocket you can send all your "
            + "messages even when sitting in a hall or in the cinema pretty near "
            + "the back.\n\n"
            + "Giant Wing\nAn unbelievable sailplane! It is amazingly robust and "
            + "can even do aerobatics. But it is best suited to gliding.\n\n"
            + "Cone Head Rocket\nThis paper arrow can be thrown with big swing. "
            + "We launched it from the roof of a hotel. It stayed in the air a "
            + "long time and covered a considerable distance.\n\n"
            + "Super Dart\nThe super dart can fly giant loops with a radius of 4 "
            + "or 5 meters and cover very long distances. Its heavy cone point is "
            + "slightly bowed upwards to get the lift required for loops.\n\n"
            + "Visit us on our Web site at www.kraxi.com!";

        try {
            p = new pdflib();

            p.set_parameter("SearchPath", searchpath);

            /* This means we must check return values of load_font() etc. */
            p.set_parameter("errorpolicy", "return");

            if (p.begin_document(outfile,
                    "destination={type=fitwindow} pagelayout=singlepage") == -1) {
                throw new Exception("Error: " + p.get_errmsg());
            }

            p.set_info("Creator", "PDFlib starter sample");
            p.set_info("Title", "starter_block");

            /* Open the Block template which contains PDFlib Blocks */
            indoc = p.open_pdi_document(infile, "");
            if (indoc == -1) {
                throw new Exception("Error: " + p.get_errmsg());
            }

            /* Open the first page and clone the page size */
            inpage = p.open_pdi_page(indoc, 1, "cloneboxes");
            if (inpage == -1) {
                throw new Exception("Error: " + p.get_errmsg());
            }

            image = p.load_image("auto", imagefile, "");

            if (image == -1) {
                throw new Exception("Error: " + p.get_errmsg());
            }

            /*
             * Based on the imported page generate several pages with the blocks
             * being filled with data related to different persons
             */
            for (i = 0; i < persons.length; i++) {
                /* Start the output page with a dummy size */
                p.begin_page_ext(10, 10, "");

                /*
                 * Place the imported page on the output page, and clone all
                 * page boxes which are present in the input page; this will
                 * override the dummy size used in begin_page_ext().
                 */
                p.fit_pdi_page(inpage, 0, 0, "cloneboxes");

                /* Option list for text blocks */
                optlist = "encoding=winansi embedding";

                /*
                 * Loop over all person-related blocks. Fill the j-th block with
                 * the corresponding entry of the persons array.
                 */
                for (j = 0; j < addressblocks.length; j++) {
                    if (p.fill_textblock(inpage, addressblocks[j],
                            persons[i][j], optlist) == -1)
                        System.err.println("Warning: " + p.get_errmsg());
                }

                /* Fill the "intro" block */
                buf = intro + " " + persons[i][0] + ",";
                if (p.fill_textblock(inpage, "intro", buf, optlist) == -1)
                    System.err.println("Warning: " + p.get_errmsg());

                /* Fill the "announcement" block */
                if (p.fill_textblock(inpage, "announcement", announcement,
                        optlist) == -1)
                    System.err.println("Warning: " + p.get_errmsg());

                /* Fill the "goodbye" block */
                if (p.fill_textblock(inpage, "goodbye", goodbye, optlist) == -1)
                    System.err.println("Warning: " + p.get_errmsg());

                /* Fill the image block */
                if (p.fill_imageblock(inpage, "icon", image, "") == -1)
                    System.err.println("Warning: " + p.get_errmsg());

                p.end_page_ext("");
            }

            p.close_pdi_page(inpage);
            p.close_pdi_document(indoc);
            p.close_image(image);

            p.end_document("");
        }
        catch (PDFlibException e) {
            System.err.print("PDFlib exception occurred:\n");
            System.err.print("[" + e.get_errnum() + "] " + e.get_apiname()
                    + ": " + e.get_errmsg() + "\n");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        finally {
            if (p != null) {
                p.delete();
            }
        }
    }
}
