/* $Id: starter_portfolio.c,v 1.11 2009/09/03 10:35:40 tm Exp $
 *
 * PDF portfolio starter:
 * Package multiple PDF and other documents into a PDF portfolio
 * The generated PDF portfolio requires Acrobat 9 for proper
 * viewing. The documents in the Portfolio will be assigned predefined
 * and custom metadata fields; for the custom fields a schema description
 * is created.
 *
 * Acrobat 8 will only display a "PDF package" with a flat list of documents
 * without any folder structure.
 *
 * Required software: PDFlib/PDFlib+PDI/PPS 8
 * Required data: PDF and other input documents
 */

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

class starter_portfolio {
    public static void main(String argv[]) {
        /* This is where the data files are. Adjust as necessary. */
        final String searchpath = "../data";
        String optlist;
        int i, font, folder;
        pdflib p = null;

        class document {
            document(String filename, String description, String status, int id) {
                this.filename = filename;
                this.description = description;
                this.status = status;
                this.id = id;
            }

            String filename;
            String description;
            String status;
            int id;
        }

        /* The documents for the Portfolio along with description and metadata */
        document root_folder_docs[] = {
            new document("TIR_____.AFM", "Metrics for Times-Roman", "internal",
                    200),
            new document("nesrin.jpg", "Zabrisky point", "archived", 300) };

        document datasheet_docs[] = {
            new document("PDFlib-real-world.pdf", "PDFlib in the real world",
                    "published", 100),
            new document("PDFlib-datasheet.pdf", "Generate PDF on the fly",
                    "published", 101),
            new document("TET-datasheet.pdf",
                    "Extract text and images from PDF", "published", 102),
            new document("PLOP-datasheet.pdf",
                    "PDF Linearization, Optimization, Protection", "published",
                    103),
            new document("pCOS-datasheet.pdf",
                    "PDF Information Retrieval Tool", "published", 104) };

        try {
            p = new pdflib();
            p.set_parameter("SearchPath", searchpath);

            /* This means we must check return values of load_font() etc. */
            p.set_parameter("errorpolicy", "return");

            if (p.begin_document("starter_portfolio.pdf",
                    "compatibility=1.7ext3") == -1) {
                throw new Exception("Error: " + p.get_errmsg());
            }

            p.set_info("Creator", "PDFlib starter sample");
            p.set_info("Title", "starter_portfolio");

            /*
             * Insert all files for the root folder along with their description
             * and the following custom fields: status string describing the
             * document status id numerical identifier, prefixed with "PHX"
             */
            for (i = 0; i < root_folder_docs.length; i++) {
                optlist = "description={" + root_folder_docs[i].description
                        + "} " + "fieldlist={ {key=status value="
                        + root_folder_docs[i].status + "} {key=id value="
                        + root_folder_docs[i].id + " prefix=PHX type=text} }";

                /* -1 means root folder */
                p.add_portfolio_file(-1, root_folder_docs[i].filename, optlist);
            }

            /* Create the "datasheets" folder in the root folder */
            folder = p.add_portfolio_folder(-1, "datasheets", "");

            /*
             * Insert documents in the "datasheets" folder along with
             * description and custom fields
             */
            for (i = 0; i < datasheet_docs.length; i++) {
                optlist = "description={" + datasheet_docs[i].description
                        + "} fieldlist={ {key=status value="
                        + datasheet_docs[i].status + "} {key=id value="
                        + datasheet_docs[i].id + " prefix=PHX type=text} }";

                /* Add the file to the "datasheets" folder */
                p.add_portfolio_file(folder, datasheet_docs[i].filename,
                        optlist);
            }

            /* Create a single-page document as cover sheet */
            p.begin_page_ext(0, 0, "width=a4.width height=a4.height");

            font = p.load_font("Helvetica", "winansi", "");
            if (font == -1) {
                throw new Exception("Error: " + p.get_errmsg());
            }

            p.setfont(font, 24);
            p.fit_textline("Welcome to the PDFlib Portfolio sample!", 50, 700, "");

            p.end_page_ext("");

            /* Set options for Portfolio display */
            optlist = "portfolio={initialview=detail ";

            /* Add schema definition for Portfolio metadata */
            optlist += 
                "schema={ "
                
                /* Some predefined fields are included here to make them visible. */
                + "{order=1 label=Name key=_filename visible editable} "
                + "{order=2 label=Description key=_description visible} "
                + "{order=3 label=Size key=_size visible} "
                + "{order=4 label={Last edited} key=_moddate visible} "

                /* User-defined fields */
                + "{order=5 label=Status key=status type=text editable} "
                + "{order=6 label=ID key=id type=text editable} ";

            optlist += "}}";

            p.end_document(optlist);
        }
        catch (PDFlibException e) {
            System.err.print("PDFlib exception occurred:\n");
            System.err.print("[" + e.get_errnum() + "] " + e.get_apiname()
                    + ": " + e.get_errmsg() + "\n");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        finally {
            if (p != null) {
                p.delete();
            }
        }
    }
}
