/* $Id: starter_tagged.java,v 1.4 2009/09/10 08:43:07 stm Exp $
 *
 * Tagged PDF starter:
 * Create document with structure information for reflow and accessibility
 *
 * required software: PDFlib/PDFlib+PDI/PPS 7
 * required data: none (dummy text created in program)
 */

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

public class starter_tagged {
    public static void main(String argv[]) {
        /* This is where the data files are. Adjust as necessary. */
        String searchpath = "../data";

        pdflib p = null;
        int id, id2, id_artifact, font;

        try {
            p = new pdflib();

            p.set_parameter("SearchPath", searchpath);

            /* This means we must check return values of load_font() etc. */
            p.set_parameter("errorpolicy", "return");

            if (p.begin_document("starter_tagged.pdf",
					"tagged=true lang=en") == -1) {
                throw new Exception("Error: " + p.get_errmsg());
	    }

            p.set_info("Creator", "PDFlib starter sample");
            p.set_info("Title", "starter_tagged");

            /* Automatically create spaces between chunks of text */
            p.set_parameter("autospace", "true");

            /*
             * open the first structure element as a child of the document
             * structure root (=0)
             */
	    id = p.begin_item("Document",
		    "Title = {Starter sample for Tagged PDF}");

	    p.begin_page_ext(0, 0,
		    "width=a4.width height=a4.height taborder=structure");

	    p.create_bookmark("Section 1", "");

            font = p.load_font("Helvetica", "winansi", "");

            if (font == -1)
                throw new Exception("Error: " + p.get_errmsg());

            p.setfont(font, 24.0);

	    id2 = p.begin_item("H1", "Title = {Introduction}");
	    p.show_xy("1 Introduction", 50, 700);
	    p.end_item(id2);

	    id2 = p.begin_item("P", "Title = {Simple paragraph}");
	    p.setfont(font, 12.0);
	    p.continue_text("This PDF has a very simple document structure ");
	    p.continue_text("which demonstrates basic Tagged PDF features ");
	    p.continue_text("for accessibility.");

	    p.end_item(id2);

            /*
             * The page number is created as an artifact; it will be ignored
             * when reflowing the page in Acrobat.
             */
            id_artifact = p.begin_item("Artifact", "");
            p.show_xy("Page 1", 250, 100);
            p.end_item(id_artifact);

            p.end_page_ext("");

            p.end_item(id);
            p.end_document("");
        }
        catch (PDFlibException e) {
            System.err.print("PDFlib exception occurred:\n");
            System.err.print("[" + e.get_errnum() + "] " + e.get_apiname()
                    + ": " + e.get_errmsg() + "\n");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        finally {
            if (p != null) {
                p.delete();
            }
        }
    }
}
