#!/usr/bin/perl
# $Id: hello.pl,v 1.31 2009/11/23 15:33:25 rjs Exp $
#
# PDFlib client: hello example in Perl
#

use PDFlib::PDFlib 8.0;
use strict;

eval {
    my $p = new PDFlib::PDFlib;

    # This means we must check return values of load_font() etc.
    $p->set_parameter("errorpolicy", "return");

    # This line is required to avoid problems on Japanese systems
    $p->set_parameter("hypertextencoding", "winansi");

    if ($p->begin_document("hello.pdf", "") == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    $p->set_info("Creator", "hello.pl");
    $p->set_info("Author", "Thomas Merz");
    $p->set_info("Title", "Hello world (Perl)!");

    $p->begin_page_ext(595, 842, "");

    my $font = $p->load_font("Helvetica-Bold", "winansi", "");
    if ($font == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    $p->setfont($font, 24.0);
    $p->set_text_pos(50, 700);
    $p->show("Hello world!");
    $p->continue_text("(says Perl)");
    $p->end_page_ext("");

    $p->end_document("");
};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
