#!/usr/bin/perl
# $Id: image.pl,v 1.27 2009/11/23 15:33:25 rjs Exp $
#
# PDFlib client: image example in Perl
#

use PDFlib::PDFlib 8.0;

# This is where font/image/PDF input files live. Adjust as necessary.
my $searchpath = "../data";
my $imagefile = "nesrin.jpg";

my $p = new PDFlib::PDFlib;

eval {
    # This means we must check return values of load_font() etc.
    $p->set_parameter("errorpolicy", "return");

    $p->set_parameter("SearchPath", $searchpath);

    # This line is required to avoid problems on Japanese systems
    $p->set_parameter("hypertextencoding", "winansi");

    if ($p->begin_document("image.pdf", "") == -1){
	die("Error: %s\n", $p->get_errmsg());
    }

    $p->set_info("Creator", "image.pl");
    $p->set_info("Author", "Thomas Merz");
    $p->set_info("Title", "image sample (Perl)");

    my $image = $p->load_image("auto", $imagefile, "");
    die "Couldn't open image '$imagefile'" if ($image == -1);

    # dummy page size, will be adjusted by $p->fit_image()
    $p->begin_page_ext(10, 10, "");
    $p->fit_image($image, 0, 0, "adjustpage");
    $p->close_image($image);
    $p->end_page_ext("");

    $p->end_document("");
};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
