#!/usr/bin/perl
# $Id: invoice.pl,v 1.25 2009/11/23 15:33:25 rjs Exp $
#
# PDFlib client: invoice generation demo
#

use PDFlib::PDFlib 8.0;
use strict;

my $left = 55;
my $right = 530;
my $fontsize = 12;
my $pagewidth = 595;
my $pageheight = 842;
my $fontsize = 12;
my $searchpath = "../data";
my $infile = "stationery.pdf";
my $baseopt =  "ruler        {   30 45     275   375   475} " .
	    "tabalignment {right left right right right} " .
	    "hortabmethod ruler fontsize 12 ";

# This is where font/image/PDF input files live. Adjust as necessary.
my $closingtext =
	"Terms of payment: <fillcolor={rgb 1 0 0}>30 days net. " .
	"<fillcolor={gray 0}>90 days warranty starting at the day of sale. " .
	"This warranty covers defects in workmanship only. " .
	"<fontname=Helvetica-BoldOblique encoding=host>Kraxi Systems, Inc. " .
	"<resetfont>will, at its option, repair or replace the " .
	"product under the warranty. This warranty is not transferable. " .
	"No returns or exchanges will be accepted for wet products.";

my @data = (   {name=>"Super Kite", 	price=>20,	quantity=>2},
	    {name=>"Turbo Flyer", 	price=>40, 	quantity=>5},
	    {name=>"Giga Trasch", 	price=>180, 	quantity=>1},
	    {name=>"Bare Bone Kit", 	price=>50, 	quantity=>3},
	    {name=>"Nitty Gritty", 	price=>20, 	quantity=>10},
	    {name=>"Pretty Dark Flyer",	price=>75, 	quantity=>1},
	    {name=>"Free Gift", 	price=>0, 	quantity=>1}
	);

my @months = ( "January", "February", "March", "April", "May", "June",
	    "July", "August", "September", "October", "November", "December");

eval {
    my $p = new PDFlib::PDFlib;

    # This means we must check return values of load_font() etc.
    $p->set_parameter("errorpolicy", "return");

    $p->set_parameter("SearchPath", $searchpath);

    # This line is required to avoid problems on Japanese systems
    $p->set_parameter("hypertextencoding", "winansi");

    if ($p->begin_document("invoice.pdf", "") == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    $p->set_info("Creator", "invoice.pl");
    $p->set_info("Author", "Thomas Merz");
    $p->set_info("Title", "PDFlib invoice generation demo (Perl)");

    my $stationery = $p->open_pdi_document($infile, "");
    if ($stationery == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    my $page = $p->open_pdi_page($stationery, 1, "");
    if ($page == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    my $boldfont = $p->load_font("Helvetica-Bold", "winansi", "");
    if ($boldfont == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }
    my $regularfont = $p->load_font("Helvetica", "winansi", "");
    if ($regularfont == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }
    my $leading = $fontsize + 2;

    # Establish coordinates with the origin in the upper left corner.
    $p->begin_page_ext($pagewidth, $pageheight, "topdown");

    $p->fit_pdi_page($page, 0, $pageheight, "");
    $p->close_pdi_page($page);

    $p->setfont($regularfont, $fontsize);

    # print the address
    my $y = 170;
    $p->set_value("leading", $leading);

    $p->show_xy("John Q. Doe", $left, $y);
    $p->continue_text("255 Customer Lane");
    $p->continue_text("Suite B");
    $p->continue_text("12345 User Town");
    $p->continue_text("Everland");

    # print the header and date
    $p->setfont($boldfont, $fontsize);
    $y = 300;
    $p->show_xy("INVOICE", $left, $y);

    my $buf = sprintf("%s %d, %d", $months[(localtime)[4]], (localtime)[3],
    (localtime)[5]+1900);
    $p->fit_textline($buf, $right, $y, "position {100 0}");


    # print the invoice header line
    $y = 370;
    $buf = sprintf("\tITEM\tDESCRIPTION\tQUANTITY\tPRICE\tAMOUNT");
    my $optlist = sprintf("%s font %d", $baseopt, $boldfont);

    my $textflow = $p->create_textflow($buf, $optlist);

    if ($textflow == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    $p->fit_textflow($textflow, $left, $y-$leading, $right, $y, "");
    $p->delete_textflow($textflow);

    # print the article list

    $y += 2*$leading;
    my $total = 0;

    $optlist = sprintf("%s font %d", $baseopt, $regularfont);

    for (my $i = 0; $i <= $#data; $i++) {
	my $sum = $data[$i]{price}*$data[$i]{quantity};

	$buf = sprintf("\t%d\t%s\t%d\t%.2f\t%.2f",
	    $i+1, $data[$i]{name}, $data[$i]{quantity}, $data[$i]{price}, $sum);

	$textflow = $p->create_textflow($buf, $optlist);

	if ($textflow == -1) {
	    die("Error: %s\n", $p->get_errmsg());
	}

	$p->fit_textflow($textflow, $left, $y-$leading, $right, $y, "");
	$p->delete_textflow($textflow);

	$y += $leading;
	$total +=$sum;
    }

    $y += $leading;
    $p->setfont($boldfont, $fontsize);
    $p->fit_textline(sprintf("%.2f",$total), $right, $y, "position {100 0}");

    # Print the closing text

    $y +=5*$leading;
    $optlist =  "alignment=justify leading=120% " .
		"fontname=Helvetica fontsize=12 encoding=winansi ";

    $textflow = $p->create_textflow($closingtext, $optlist);

    if ($textflow == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    $p->fit_textflow($textflow, $left, $y + 6*$leading, $right, $y, "");
    $p->delete_textflow($textflow);

    $p->end_page_ext("");
    $p->end_document("");
    $p->close_pdi_document($stationery);
};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
