#!/usr/bin/perl
# $Id: starter_3d.pl,v 1.1.2.1 2011/05/10 17:41:39 rjs Exp $
# 3D Starter:
# Load a 3D model and create a 3D annotation from it.
#
# Define a 3D view and load some 3D data with the view defined. Then create
# an annotation containing the loaded 3D data with the defined 3D view as the
# initial view.
#
# Required software: PDFlib/PDFlib+PDI/PPS 8.0.3
# Required data: PRC data file
#

use pdflib_pl 8.0;

# This is where the data files are. Adjust if necessary.
$searchpath = "../data";
$outfile = "starter_3d.pdf";

$p = PDF_new();

eval {
    PDF_set_parameter($p, "SearchPath", $searchpath);

    # This means we must check return values of load_font() etc.
    PDF_set_parameter($p, "errorpolicy", "return");

    # Start the document
    if (PDF_begin_document($p, $outfile, "compatibility=1.7ext3") == -1) {
	die("Error: %s\n", PDF_get_errmsg($p));
    }

    PDF_set_info($p, "Creator", "PDFlib starter sample");
    PDF_set_info($p, "Title", "starter_3d");

    $font = PDF_load_font($p, "Helvetica", "winansi", "");
    if ($font == -1) {
	die("Error: %s\n", PDF_get_errmsg($p));
    }

    PDF_begin_page_ext($p, 0, 0, "width=a4.width height=a4.height");

    # Define a 3D view which shows the model from the top
    $optlist = "type=PRC name=FirstView background={fillcolor=Lavender} " .
		"camera2world={-1 0 0 0 1 0 0 0 -1 0.5 0 300}";
    if (($view = PDF_create_3dview($p, "First view", $optlist)) == -1) {
	die("Error: %s\n", PDF_get_errmsg($p));
    }

    # Load some 3D data with the view defined above
    $buf = "type=PRC views={$view}";
    if (($data = PDF_load_3ddata($p, "riemann.prc", $buf)) == -1) {
	die("Error: %s\n", PDF_get_errmsg($p));
    }

    # Create an annotation containing the loaded 3D data with the
    # defined 3D view as the initial view
    #
    $buf = "name=annot usercoordinates contents=PRC 3Ddata=$data 3Dactivate={enable=open} 3Dinitialview=$view";
    PDF_create_annotation($p, 116, 200, 447, 580, "3D", $buf);

    PDF_end_page_ext($p, "");

    PDF_end_document($p, "");

};

if ($@) {
    printf("$0: PDFlib Exception occurred:\n");
    printf(" $@\n");
    exit(1);
}

PDF_delete($p);
