#!/usr/bin/perl
# $Id: starter_tagged.pl,v 1.1 2009/11/23 14:31:31 rjs Exp $
#
# Tagged PDF starter:
# Create document with structure information for reflow and accessibility
#
# required software: PDFlib/PDFlib+PDI/PPS 7
# required data: none (dummy text created in program)

use pdflib_pl 7.0;

# This is where the data files are. Adjust as necessary.
$searchpath = "../data";
$outfilename = "starter_tagged.pdf";

$p = PDF_new();

eval {
    # This means we must check return values of load_font() etc.
    PDF_set_parameter($p, "errorpolicy", "return");

    PDF_set_parameter($p, "SearchPath", $searchpath);

    if (PDF_begin_document($p, $outfilename, "tagged=true lang=en") == -1) {
	die("Error: " . PDF_get_errmsg($p));
    }

    PDF_set_info($p, "Creator", "PDFlib starter sample");
    PDF_set_info($p, "Title", "starter_tagged");

    # Automatically create spaces between chunks of text
    PDF_set_parameter($p, "autospace", "true");

    # open the first structure element as a child of the document
    # structure root (=0)
    
    my $id = PDF_begin_item($p, "Document",
	    "Title = {Starter sample for Tagged PDF}");

    PDF_begin_page_ext($p, 0, 0,
	    "width=a4.width height=a4.height taborder=structure");

    PDF_create_bookmark($p, "Section 1", "");

    $font = PDF_load_font($p, "Helvetica", "winansi", "");
    if ($font == -1) {
	die("Error: %s\n", PDF_get_errmsg($p));
    }
    PDF_setfont($p, $font, 24.0);

    my $id2 = PDF_begin_item($p, "H1", "Title = {Introduction}");
    PDF_show_xy($p, "1 Introduction", 50, 700);
    PDF_end_item($p, $id2);

    $id2 = PDF_egin_item($p, "P", "Title = {Simple paragraph}");
    PDF_setfont($p, $font, 12.0);
    PDF_continue_text($p, "This PDF has a very simple document structure ");
    PDF_continue_text($p, "which demonstrates basic Tagged PDF features ");
    PDF_continue_text($p, "for accessibility.");

    PDF_end_item($p, $id2);

    # The page number is created as an artifact; it will be
    # ignored when reflowing the page in Acrobat.

    $id_artifact = PDF_begin_item($p, "Artifact", "");
    PDF_show_xy($p, "Page 1", 250, 100);
    PDF_end_item($p, $id_artifact);

    PDF_end_page_ext($p, "");

    PDF_end_item($p, $id);
    PDF_end_document($p, "");

    PDF_delete($p);
};

if ($@) {
    printf("$0: PDFlib Exception occurred:\n");
    printf(" $@\n");
    exit(1);
}
