#!/usr/bin/perl
# $Id: pdfclock.cgi.pl,v 1.16 2009/11/23 14:31:30 rjs Exp $
#
# PDFlib client: pdfclock CGI example in Perl
#

use PDFlib::PDFlib 8.0;
use strict;

my $RADIUS = 200.0;
my $MARGIN = 20.0;

my $p = new PDFlib::PDFlib;

# This means we must check return values of load_font() etc.
$p->set_parameter("errorpolicy", "return");

# This line is required to avoid problems on Japanese systems
$p->set_parameter("hypertextencoding", "winansi");

$p->begin_document("", "");

$p->set_info("Creator", "pdfclock.cgi.pl");
$p->set_info("Author", "Thomas Merz");
$p->set_info("Title", "PDF clock (Perl/CGI)");

$p->begin_page_ext(2 * ($RADIUS + $MARGIN), 2 * ($RADIUS + $MARGIN), "");

$p->translate($RADIUS + $MARGIN, $RADIUS + $MARGIN);
$p->setcolor("fillstroke", "rgb", 0.0, 0.0, 1.0, 0.0);
$p->save();

# minute strokes 
$p->setlinewidth(2.0);
for (my $alpha = 0; $alpha < 360; $alpha += 6) {
    $p->rotate(6.0);
    $p->moveto($RADIUS, 0.0);
    $p->lineto($RADIUS-$MARGIN/3, 0.0);
    $p->stroke();
}

$p->restore();
$p->save();

# 5 minute strokes
$p->setlinewidth(3.0);
for (my $alpha = 0; $alpha < 360; $alpha += 30) {
    $p->rotate(30.0);
    $p->moveto($RADIUS, 0.0);
    $p->lineto($RADIUS-$MARGIN, 0.0);
    $p->stroke();
}

my ($tm_sec,$tm_min,$tm_hour) = localtime(time);

# draw hour hand 
$p->save();
$p->rotate((-(($tm_min/60.0) + $tm_hour - 3.0) * 30.0));
$p->moveto(-$RADIUS/10, -$RADIUS/20);
$p->lineto($RADIUS/2, 0.0);
$p->lineto(-$RADIUS/10, $RADIUS/20);
$p->closepath();
$p->fill();
$p->restore();

# draw minute hand
$p->save();
$p->rotate((-(($tm_sec/60.0) + $tm_min - 15.0) * 6.0));
$p->moveto(-$RADIUS/10, -$RADIUS/20);
$p->lineto($RADIUS * 0.8, 0.0);
$p->lineto(-$RADIUS/10, $RADIUS/20);
$p->closepath();
$p->fill();
$p->restore();

# draw second hand
$p->setcolor("fillstroke", "rgb", 1.0, 0.0, 0.0, 0.0);
$p->setlinewidth(2);
$p->save();
$p->rotate(-(($tm_sec - 15.0) * 6.0));
$p->moveto(-$RADIUS/5, 0.0);
$p->lineto($RADIUS, 0.0);
$p->stroke();
$p->restore();

# draw little circle at center
$p->circle(0, 0, $RADIUS/30);
$p->fill();

$p->restore();
$p->end_page_ext("");

$p->end_document("");

my $buf = $p->get_buffer();

# the following is required on Windows systems
binmode(STDOUT);

print "Content-Type: application/pdf\n";
print "Content-Length: " . length($buf) . "\n";
print "Content-Disposition: inline; filename=" . "pdfclock.cgi.pl.pdf" . "\n\n";
print $buf;
