#!/usr/bin/perl
# $Id: starter_3d.pl,v 1.7.2.1 2011/05/10 17:41:38 rjs Exp $
# 3D Starter:
# Load a 3D model and create a 3D annotation from it.
#
# Define a 3D view and load some 3D data with the view defined. Then create
# an annotation containing the loaded 3D data with the defined 3D view as the
# initial view.
#
# Required software: PDFlib/PDFlib+PDI/PPS 8.0.3
# Required data: PRC data file
#

use PDFlib::PDFlib 8.0;
use strict;

# This is where the data files are. Adjust if necessary.
my $searchpath = "../data";
my $outfile = "starter_3d.pdf";

my $view;
my $data;

eval {
    my $p = new PDFlib::PDFlib;

    $p->set_parameter("SearchPath", $searchpath);

    # This means we must check return values of load_font() etc.
    $p->set_parameter("errorpolicy", "return");

    # Start the document
    if ($p->begin_document($outfile, "compatibility=1.7ext3") == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    $p->set_info("Creator", "PDFlib starter sample");
    $p->set_info("Title", "starter_3d");

    my $font = $p->load_font("Helvetica", "winansi", "");
    if ($font == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    $p->begin_page_ext(0, 0, "width=a4.width height=a4.height");

    # Define a 3D view which shows the model from the top
    my $optlist = "type=PRC name=FirstView background={fillcolor=Lavender} " .
		"camera2world={-1 0 0 0 1 0 0 0 -1 0.5 0 300}";
    if (($view = $p->create_3dview("First view", $optlist)) == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    # Load some 3D data with the view defined above
    my $buf = "type=PRC views={$view}";
    if (($data = $p->load_3ddata("riemann.prc", $buf)) == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    # Create an annotation containing the loaded 3D data with the
    # defined 3D view as the initial view
    #
    $buf = "name=annot usercoordinates contents=PRC 3Ddata=$data 3Dactivate={enable=open} 3Dinitialview=$view";
    $p->create_annotation(116, 200, 447, 580, "3D", $buf);

    $p->end_page_ext("");

    $p->end_document("");

};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
