#!/usr/bin/perl
# $Id: starter_pcos.pl,v 1.13 2009/11/23 15:33:25 rjs Exp $
#
# pCOS starter:
# Dump information from an existing PDF document
#
# required software: PDFlib+PDI/PPS 7
# required data: PDF input file

use PDFlib::PDFlib 7.0;
use strict;

# This is where the data files are. Adjust as necessary.
my $searchpath = "../data";
my $pdfinput = "TET-datasheet.pdf";
my $docoptlist = "requiredmode=minimum";

eval {
    my $p = new PDFlib::PDFlib;

    # This means we must check return values of load_font() etc.
    $p->set_parameter("errorpolicy", "return");

    $p->set_parameter("SearchPath", $searchpath);

    # We do not create any output document, so no call to
    # begin_document() is required.

    # Open the input document
    my $doc = $p->open_pdi_document($pdfinput, $docoptlist);
    if ($doc == -1) {
	die("Error: " . $p->get_errmsg());
    }

    # --------- general information (always available)

    my $pcosmode = $p->pcos_get_number($doc, "pcosmode");

    printf("   File name: %s\n",
	$p->pcos_get_string($doc,"filename"));

    printf(" PDF version: %s\n",
	$p->pcos_get_string($doc, "pdfversionstring"));

    printf("  Encryption: %s\n",
	$p->pcos_get_string($doc, "encrypt/description"));

    printf("   Master pw: %s\n",
	(($p->pcos_get_number($doc, "encrypt/master") != 0) ? "yes":"no"));

    printf("     User pw: %s\n",
	(($p->pcos_get_number($doc, "encrypt/user") != 0) ? "yes" : "no"));

    printf("Text copying: %s\n",
	(($p->pcos_get_number($doc, "encrypt/nocopy") != 0) ? "no":"yes"));

    printf("  Linearized: %s\n\n",
	(($p->pcos_get_number($doc, "linearized") != 0) ? "yes" : "no"));

    if ($pcosmode == 0) {
	printf("Minimum mode: no more information available\n\n");
	exit(0);
    }

    # --------- more details (requires at least user password)
    printf("PDF/X status: %s\n", $p->pcos_get_string($doc, "pdfx"));

    printf("PDF/A status: %s\n", $p->pcos_get_string($doc, "pdfa"));

    my $xfa_present =
        $p->pcos_get_number($doc, "type:/Root/AcroForm/XFA") != 0;
    printf("    XFA data: %s\n", $xfa_present ? "yes" : "no");
        
    printf("  Tagged PDF: %s\n",
        (($p->pcos_get_number($doc, "tagged") != 0) ? "yes" : "no"));

    printf("No. of pages: %s\n",
	$p->pcos_get_number($doc, "length:pages"));

    printf(" Page 1 size: width=%.3f, height=%.3f\n",
	 $p->pcos_get_number($doc, "pages[0]/width"),
	 $p->pcos_get_number($doc, "pages[0]/height"));

    my $count = $p->pcos_get_number($doc, "length:fonts");
    printf("No. of fonts: %s\n",  $count);

    for (my $i=0; $i < $count; $i++) {
	my $fonts = "fonts[" . $i . "]/embedded";
	if ($p->pcos_get_number($doc, $fonts) != 0) {
	    print("embedded ");
	} else {
	    print("unembedded ");
	}

	$fonts = "fonts[" . $i . "]/type";
	print($p->pcos_get_string($doc, $fonts) . " font ");
	$fonts = "fonts[" . $i . "]/name";
	printf("%s\n", $p->pcos_get_string($doc, $fonts));
    }

    printf("\n");

    my $plainmetadata =
                $p->pcos_get_number($doc, "encrypt/plainmetadata") != 0;

    if ($pcosmode == 1 && !$plainmetadata
            && $p->pcos_get_number($doc, "encrypt/nocopy") != 0) {
	print("Restricted mode: no more information available");
	exit(0);
    }

    # ----- document $info keys and XMP metadata (requires master pw)

    my $count = $p->pcos_get_number($doc, "length:/Info");

    for (my $i=0; $i < $count; $i++) {
	my $info = "type:/Info[" . $i . "]";
	my $objtype = $p->pcos_get_string($doc, $info);

	$info = "/Info[" . $i . "].key";
	my $key = $p->pcos_get_string($doc, $info);
	my $len = 12 - length($key);
	while ($len-- > 0) {
	    print(" ");
	}

	print($key . ": ");

	# $info entries can be stored as string or name objects
	if ($objtype eq "name" || $objtype eq "string") {
	    $info = "/Info[" . $i . "]";
	    printf("'" . $p->pcos_get_string($doc, $info) .  "'\n");
	}
        else {
	    $info = "type:/Info[" . $i . "]";
	    printf("(" . $p->pcos_get_string($doc, $info) .  " object)\n");
	}
    }

    print("\n" . "XMP metadata: ");

    my $objtype = $p->pcos_get_string($doc, "type:/Root/Metadata");
    if ($objtype eq "stream") {
	my $contents = $p->pcos_get_stream($doc, "", "/Root/Metadata");
	print(length($contents) . " bytes \n");
	printf("");
    }
    else {
	printf("not present\n");
    }

    $p->close_pdi_document($doc);

};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
