#!/usr/bin/perl
# $Id: starter_pdfa1b.pl,v 1.5.2.1 2010/01/29 11:10:01 rjs Exp $
#
# PDF/A-1b starter:
# Create PDF/A-1b conforming output
#
# Required software: PDFlib/PDFlib+PDI/PPS 7
# Required data: font file, image file

use PDFlib::PDFlib 7.0;
use strict;

# This is where the data files are. Adjust as necessary.
my $searchpath = "../data";
my $imagefile = "nesrin.jpg";
my $outfilename = "starter_pdfa1b.pdf";

eval {
    my $p = new PDFlib::PDFlib;

    # This means we must check return values of load_font() etc.
    $p->set_parameter("errorpolicy", "return");

    $p->set_parameter("SearchPath", $searchpath);
    $p->set_parameter("textformat", "bytes");

    # PDF/A-1a requires Tagged PDF
    if ($p->begin_document($outfilename, "pdfa=PDF/A-1b:2005") == -1) {
	die("Error: " . $p->get_errmsg());
    }

    #
    # We use sRGB as output intent since it allows the color
    # spaces CIELab, ICC-based, grayscale, and RGB.
    #
    # If you need CMYK color you must use a CMYK output profile.
    

    $p->load_iccprofile("sRGB", "usage=outputintent");

    $p->set_info("Creator", "PDFlib starter sample");
    $p->set_info("Title", "starter_pdfa1b");

    $p->begin_page_ext(595, 842, "");

    # $font embedding is required for PDF/A
    my $font = $p->load_font("LuciduxSans-Oblique", "unicode", "embedding");
    if ($font == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }
    $p->setfont($font, 24);

    $p->fit_textline("PDF/A-1b:2005 starter", 50, 700, "");

    # We can use an RGB $image since we already supplied an
    # output intent profile.
    
    my $image = $p->load_image("auto", $imagefile, "");
    if ($image == -1) {
	die("Error: " . $p->get_errmsg());
    }

    # Place the $image at the bottom of the page
    $p->fit_image($image, 0.0, 0.0, "scale=0.5");

    $p->end_page_ext("");
    $p->close_image($image);

    $p->end_document("");

};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
