#!/usr/bin/perl
# $Id: starter_pdfx3.pl,v 1.5 2009/11/24 09:22:29 rjs Exp $
#
# PDF/X-3 starter:
# Create PDF/X-3 conforming output
#
# required software: PDFlib/PDFlib+PDI/PPS 7
# required data: font file, image file, icc profile
#                (see www.pdflib.com for ICC profiles)

use PDFlib::PDFlib 7.0;
use strict;

# This is where the data files are. Adjust as necessary.*/
my $searchpath = "../data";
my $imagefile = "nesrin.jpg";
my $outfilename = "starter_pdfx3.pdf";

eval {
    my $p = new PDFlib::PDFlib;

    # This means we must check return values of load_font() etc.
    $p->set_parameter("errorpolicy", "return");

    $p->set_parameter("SearchPath", $searchpath);

    if ($p->begin_document($outfilename, "pdfx=PDF/X-3:2003") == 0) {
	die("Error: " . $p->get_errmsg());
    }

    $p->set_info("Creator", "PDFlib starter sample");
    $p->set_info("Title", "starter_pdfx3");

    #
    # You can use one of the Standard output intents (e.g. for SWOP
    # printing) which do not require an ICC profile:
    #
    # $p->load_iccprofile("CGATS TR 001", "usage=outputintent");
    #
    # However, if you use ICC or Lab color you must load an ICC
    # profile as output intent:
    
    if ($p->load_iccprofile("ISOcoated.icc", "usage=outputintent") == -1) {
	printf("Error: %s\n", $p->get_errmsg());
	printf("Please install the ICC profile package from " .
	    "www.pdflib.com to run the PDF/X starter sample.\n");
	exit(2);
    }

    $p->begin_page_ext(595, 842, "");

    # $font embedding is required for PDF/X
    my $font = $p->load_font("LuciduxSans-Oblique", "unicode", "embedding");
    if ($font == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }
    $p->setfont($font, 24);

    my $spot = $p->makespotcolor("PANTONE 123 C");
    $p->setcolor("fill", "spot", $spot, 1.0, 0.0, 0.0);
    $p->fit_textline("PDF/X-3:2003 starter", 50, 700, "");

    # The RGB $image below needs an $icc profile; we use sRGB.
    my $icc = $p->load_iccprofile("sRGB", "");
    my $image = $p->load_image("auto", $imagefile, "iccprofile=" . $icc);

    if ($image == -1) {
	die("Error: " . $p->get_errmsg());
    }

    $p->fit_image($image, 0.0, 0.0, "scale=0.5");

    $p->end_page_ext("");

    $p->end_document("");

};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
