#!/usr/bin/perl
# $Id: starter_pvf.pl,v 1.6 2009/11/23 14:31:30 rjs Exp $
# PDFlib Virtual File system (PVF):
# Create a PVF file which holds an image or PDF, and import the data from the
# PVF file
#
# This avoids disk access and is especially useful when the same image or PDF
# is imported multiply. For examples, images which sit in a database don't
# have to be written and re-read from disk, but can be passed to PDFlib
# directly in memory. A similar technique can be used for loading other data
# such as fonts, ICC profiles, etc.
#
# Required software: PDFlib/PDFlib+PDI/PPS 7
# Required data: image file

use PDFlib::PDFlib 7.0;
use strict;

#
# Helper function to read the content of a file into a buffer
# avoids incompatible systemcalls

sub read_file($)
{
    my ($fname) = @_;
    my $data;

    open(INPUT, "$fname") or die "couldn't open $fname $!\n";
    binmode(INPUT);
    undef $/;
    $data = <INPUT>;
    close(INPUT);

    return $data;
} # read_file


# This is where the data files are. Adjust as necessary.
my $searchpath = "../data";
my $outfile = "starter_pvf.pdf";

my $buf;
my $p;
my $imagedata;

# create a new PDFlib object
my $p = new PDFlib::PDFlib;

eval {
    $p->set_parameter("SearchPath", $searchpath);

    # This means we must check return values of load_font() etc.
    $p->set_parameter("errorpolicy", "return");

    # Set an output path according to the name of the topic
    if ($p->begin_document($outfile, "") == -1) {
	printf("Error: %s\n", $p->get_errmsg());
	exit(2);
    }

    $p->set_info("Creator", "PDFlib starter sample");
    $p->set_info("Title", "starter_pvf");

    # We just read some image data from a file; to really benefit
    # from using PVF read the data from a Web site or a database instead

    $imagedata = read_file("../data/PDFlib-logo.tif");

    $p->create_pvf("/pvf/image", $imagedata, "");

    # Load the image from the PVF
    my $image = $p->load_image("auto", "/pvf/image", "");
    if ($image == -1) {
	printf("Error: %s\n", $p->get_errmsg());
	exit(2);
    }

    # Fit the image on page 1
    $p->begin_page_ext(595, 842, "");

    $p->fit_image($image, 350, 750, "");

    $p->end_page_ext("");

    # Fit the image on page 2
    $p->begin_page_ext(595, 842, "");

    $p->fit_image($image, 350, 50, "");

    $p->end_page_ext("");

    # Delete the virtual file to free the allocated memory
    $p->delete_pvf("/pvf/image");

    $p->end_document("");

};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
