#!/usr/bin/perl
# $Id: starter_table.pl,v 1.9 2009/11/24 09:22:29 rjs Exp $
#
# Table starter:
# Create table which may span multiple pages
#
# required software: PDFlib/PDFlib+PDI/PPS 7
# required data: image file (dummy text created within the program)

use PDFlib::PDFlib 7.0;
use strict;

# This is where the data files are. Adjust as necessary.
my $searchpath = "../data";
my $imagefile = "nesrin.jpg";
my $outfilename = "starter_table.pdf";

my $tf=-1;
my $tbl=-1;
my $rowmax = 50;
my $colmax = 5;
my $llx= 50;
my $lly=50;
my $urx=550;
my $ury=800;

my $headertext = "Table header (centered across all columns)";

# Dummy text for filling a cell with multi-line Textflow
my $tf_text = 
"Lorem ipsum dolor sit amet, consectetur adi&shy;pi&shy;sicing elit, sed do eius&shy;mod tempor incidi&shy;dunt ut labore et dolore magna ali&shy;qua. Ut enim ad minim ve&shy;niam, quis nostrud exer&shy;citation ull&shy;amco la&shy;bo&shy;ris nisi ut ali&shy;quip ex ea commodo con&shy;sequat. Duis aute irure dolor in repre&shy;henderit in voluptate velit esse cillum dolore eu fugiat nulla pari&shy;atur. Excep&shy;teur sint occae&shy;cat cupi&shy;datat non proident, sunt in culpa qui officia dese&shy;runt mollit anim id est laborum. ";

eval {
    my $p = new PDFlib::PDFlib;

    # This means we must check return values of load_font() etc.
    $p->set_parameter("errorpolicy", "return");

    $p->set_parameter("SearchPath", $searchpath);

    # we use "bytes" as textformat, this allows to use unicode encoding
    $p->set_parameter("textformat", "bytes");

    if ($p->begin_document($outfilename, "") == -1) {
	die("Error: " . $p->get_errmsg());
    }

    $p->set_info("Creator", "PDFlib starter sample");
    $p->set_info("Title", "starter_table");

    # -------------------- Add table cells --------------------

    # ---------- row 1: table header (spans all columns)
    my $row = 1; my $col = 1;
    my $font = $p->load_font("Times-Bold", "unicode", "");
    if ($font == -1) {
	printf("Error: %s\n", $p->get_errmsg()); exit;
    }

    my $optlist = "fittextline={position=center font=" . $font .
	" fontsize=14} colspan=" . $colmax;

    my $tbl = $p->add_table_cell($tbl, $col, $row, $headertext, $optlist);
    if ($tbl == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    # ---------- row 2: various kinds of content
    # ----- Simple text cell
    $row++; $col=1;

    my $optlist = "fittextline={font=" . $font . " fontsize=10 orientate=west}";

    $tbl = $p->add_table_cell($tbl, $col, $row, "vertical line", $optlist);
    if ($tbl == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    # ----- Colorized background
    $col++;

    $optlist = "fittextline={font=" . $font . " fontsize=10} " .
    "matchbox={fillcolor={rgb 0.9 0.5 0}}";

    $tbl = $p->add_table_cell($tbl, $col, $row, "some color", $optlist);
    if ($tbl == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    # ----- Multi-line text with Textflow
    $col++;
    $font = $p->load_font("Times-Roman", "unicode", "");
    if ($font == -1) {
	printf("Error: %s\n", $p->get_errmsg()); exit;
    }

    $optlist = "charref fontname=Times-Roman encoding=unicode fontsize=8 ";

    $tf = $p->add_textflow($tf, $tf_text, $optlist);
    if ($tf == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    $optlist = "margin=2 textflow=" . $tf;

    $tbl = $p->add_table_cell($tbl, $col, $row, "", $optlist);
    if ($tbl == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    # ----- Rotated $image
    $col++;

    my $image = $p->load_image("auto", $imagefile, "");
    if ($image == -1) {
	die("Couldn't load $image: " . $p->get_errmsg());
    }

    $optlist = "image=" . $image . " fitimage={orientate=west}";

    $tbl = $p->add_table_cell($tbl, $col, $row, "", $optlist);
    if ($tbl == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    # ----- Diagonal stamp
    $col++;

    $optlist = "fittextline={font=" . $font . " fontsize=10 stamp=ll2ur}";

    $tbl = $p->add_table_cell($tbl, $col, $row, "entry void", $optlist);
    if ($tbl == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }

    # ---------- Fill $row 3 and above with their numbers
    for ($row++; $row <= $rowmax; $row++) {
	for ($col = 1; $col <= $colmax; $col++) {
	    my $num = "Col " . $col . "/Row " . $row;
	    $optlist = "colwidth=20% fittextline={font=" . $font . " fontsize=10}";
	    $tbl = $p->add_table_cell($tbl, $col, $row, $num, $optlist);
	    if ($tbl == -1) {
	    die("Error: %s\n", $p->get_errmsg());
	}
	}
    }

    # ---------- Place the table on one or more pages ----------

    #
    # Loop until all of the table is placed; create new pages
    # as long as more table instances need to be placed.

    my $result;
    do {
	$p->begin_page_ext(0, 0, "width=a4.width height=a4.height");

	# Shade every other $row; draw lines for all table cells.
	# Add "showcells showborder" to visualize cell borders 

	$optlist = "header=1 fill={{area=rowodd fillcolor={gray 0.9}}} " .
	"stroke={{line=other}} ";

	# Place the table instance
	$result = $p->fit_table($tbl, $llx, $lly, $urx, $ury, $optlist);
	if ($result eq "_error") {
	    die("Couldn't place table:" . $p->get_errmsg());
	}

	$p->end_page_ext("");

    } while ($result eq "_boxfull");

    # Check the $result; "_stop" means all is ok.
    if ($result ne "_stop") {
	if ($result eq "_error") {
	    die("Error when placing table: " . $p->get_errmsg());
	} else {
	    # Any other return value is a user exit caused by
	    # the "return" option; this requires dedicated code to
	    # deal with.
	    die("User return found in Textflow");
	}
    }

    # This will also delete Textflow handles used in the table
    $p->delete_table($tbl, "");

    $p->end_document("");

};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
