#!/usr/bin/perl
# $Id: starter_tagged.pl,v 1.9.2.1 2011/07/11 12:35:29 rjs Exp $
#
# Tagged PDF starter:
# Create document with structure information for reflow and accessibility
#
# required software: PDFlib/PDFlib+PDI/PPS 7
# required data: none (dummy text created in program)

use PDFlib::PDFlib 7.0;
use strict;

# This is where the data files are. Adjust as necessary.
my $searchpath = "../data";
my $outfilename = "starter_tagged.pdf";

eval {
    my $p = new PDFlib::PDFlib;

    # This means we must check return values of load_font() etc.
    $p->set_parameter("errorpolicy", "return");

    $p->set_parameter("SearchPath", $searchpath);

    if ($p->begin_document($outfilename, "tagged=true lang=en") == -1) {
	die("Error: " . $p->get_errmsg());
    }

    $p->set_info("Creator", "PDFlib starter sample");
    $p->set_info("Title", "starter_tagged");

    # Automatically create spaces between chunks of text
    $p->set_parameter("autospace", "true");

    # open the first structure element as a child of the document
    # structure root (=0)
    
    my $id = $p->begin_item("Document",
	    "Title = {Starter sample for Tagged PDF}");

    $p->begin_page_ext(0, 0,
	    "width=a4.width height=a4.height taborder=structure");

    $p->create_bookmark("Section 1", "");

    my $font = $p->load_font("Helvetica", "winansi", "");
    if ($font == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }
    $p->setfont($font, 24.0);

    my $id2 = $p->begin_item("H1", "Title = {Introduction}");
    $p->show_xy("1 Introduction", 50, 700);
    $p->end_item($id2);

    $id2 = $p->begin_item("P", "Title = {Simple paragraph}");
    $p->setfont($font, 12.0);
    $p->continue_text("This PDF has a very simple document structure ");
    $p->continue_text("which demonstrates basic Tagged PDF features ");
    $p->continue_text("for accessibility.");

    $p->end_item($id2);

    # The page number is created as an artifact; it will be
    # ignored when reflowing the page in Acrobat.

    my $id_artifact = $p->begin_item("Artifact", "");
    $p->show_xy("Page 1", 250, 100);
    $p->end_item($id_artifact);

    $p->end_page_ext("");

    $p->end_item($id);
    $p->end_document("");

};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
