#!/usr/bin/perl
# $Id: starter_textflow.pl,v 1.9 2009/11/24 09:22:29 rjs Exp $
#
# Textflow starter:
# Create multi-column text output which may span multiple pages
#
# required software: PDFlib/PDFlib+PDI/PPS 7 or above
# required data: none

use PDFlib::PDFlib 7.0;
use strict;

my $outfilename = "starter_textflow.pdf";
my $tf = -1;
my $llx1= 50; my $lly1=50; my $urx1=250; my $ury1=800;
my $llx2=300; my $lly2=50; my $urx2=500; my $ury2=800;

# Repeat the dummy text to produce more contents
my $count = 50;

my $optlist1 = "fontname=Helvetica fontsize=10.5 encoding=unicode " .
    "fillcolor={gray 0} alignment=justify";
my $optlist2 = "fontname=Helvetica-Bold fontsize=14 encoding=unicode " .
    "fillcolor={rgb 1 0 0} charref";

# Dummy text for filling the columns. Soft hyphens are marked with
# the character reference "&shy;" (character references are
# enabled by the charref option).

my $text= 
"Lorem ipsum dolor sit amet, consectetur adi&shy;pi&shy;sicing elit, sed do eius&shy;mod tempor incidi&shy;dunt ut labore et dolore magna ali&shy;qua. Ut enim ad minim ve&shy;niam, quis nostrud exer&shy;citation ull&shy;amco la&shy;bo&shy;ris nisi ut ali&shy;quip ex ea commodo con&shy;sequat. Duis aute irure dolor in repre&shy;henderit in voluptate velit esse cillum dolore eu fugiat nulla pari&shy;atur. Excep&shy;teur sint occae&shy;cat cupi&shy;datat non proident, sunt in culpa qui officia dese&shy;runt mollit anim id est laborum. ";

eval {
    my $p = new PDFlib::PDFlib;

    # This means we must check return values of load_font() etc.
    $p->set_parameter("errorpolicy", "return");

    # we use "bytes" as textformat, this allows to use unicode encoding
    $p->set_parameter("textformat", "bytes");

    if ($p->begin_document($outfilename, "") == -1) {
	die("Error: " . $p->get_errmsg());
    }

    $p->set_info("Creator", "PDFlib starter sample");
    $p->set_info("Title", "starter_textflow");

    # Create some amount of dummy text and feed it to a Textflow
    # object with alternating options. 

    for (my $i=1; $i<=$count; $i++) {
	my $num = $i . " ";

	$tf = $p->add_textflow($tf, $num, $optlist2);
	if ($tf == -1) {
	    die("Error: " . $p->get_errmsg());
	}

	$tf = $p->add_textflow($tf, $text, $optlist1);
	if ($tf == -1) {
	    die("Error: " . $p->get_errmsg());
	}
    }

    # Loop until all of the text is placed; create new pages
    # as long as more text needs to be placed. Two columns will
    # be created on all pages.
 
    my $result;
    do {
	# Add "showborder to visualize the fitbox borders
	my $optlist = "verticalalign=justify linespreadlimit=120% ";

	$p->begin_page_ext(0, 0, "width=a4.width height=a4.height");

	# Fill the first column
	$result = $p->fit_textflow($tf, $llx1, $lly1, $urx1, $ury1, $optlist);

	# Fill the second column if we have more text*/
	if ($result ne "_stop") {
	    $result = $p->fit_textflow($tf, 
			$llx2, $lly2, $urx2, $ury2, $optlist);
	}

	$p->end_page_ext("");

	# "_boxfull" means we must continue because there is more text;
	# "_nextpage" is interpreted as "start new column"

    } while ($result eq "_boxfull" || $result eq "_nextpage");

    # Check for errors
    if ($result ne "_stop") {
	# "_boxempty" happens if the box is very small and doesn't
	# hold any text at all.

	if ($result eq "_boxempty") {
	    die("Error: Textflow box too small");
	} else {
	    # Any other return value is a user exit caused by
	    # the "return" option; this requires dedicated code to
	    # deal with.
	    die("User return '" . $result . "' found in Textflow");
	}
    }

    $p->delete_textflow($tf);

    $p->end_document("");

};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
