#!/usr/bin/perl
# $Id: starter_webform.pl,v 1.7 2009/11/23 15:33:25 rjs Exp $
#
# Webform starter:
# create a linearized PDF (for fast delivery over the Web, also known
# as "fast Web view") which is encrypted and contains some form fields.
# A few lines of JavaScript are inserted as "page open" action to
# automatically populate the date field with the current date.
#
# required software: PDFlib/PDFlib+PDI/PPS 7
# required data: none

use PDFlib::PDFlib 7.0;
use strict;

my $outfilename = "starter_webform.pdf";

my $llx=150; my $lly=550; my $urx=350; my $ury=575;

# JavaScript for automatically filling the date into a form field
my $js = "var d = util.printd(\"mm/dd/yyyy\", new Date());" .
    "var date = this.getField(\"date\");" .
    "date.value = d;";

my $p = new PDFlib::PDFlib;

eval {
    # This means we must check return values of load_font() etc.
    $p->set_parameter("errorpolicy", "return");

    # Prevent changes with a master password
    my $optlist = "linearize masterpassword=pdflib permissions={nomodify}";

    if ($p->begin_document($outfilename, $optlist) == -1) {
	die("Error: " . $p->get_errmsg());
    }

    $p->set_info("Creator", "PDFlib starter sample");
    $p->set_info("Title", "starter_webform");

    $optlist = "script={" . $js . "}";
    my $action = $p->create_action("JavaScript", $optlist);

    $optlist = "action={open=" . $action . "}";
    $p->begin_page_ext(595, 842, $optlist);

    my $font = $p->load_font("Helvetica", "winansi", "");
    if ($font == -1) {
	die("Error: %s\n", $p->get_errmsg());
    }
    $p->setfont($font, 24);

    $p->fit_textline("Date: ", 125, $lly+5, "position={right bottom}");

    # The tooltip will be used as rollover text for the field
    $optlist =
	"tooltip={Date (will be filled automatically)} " .
	"bordercolor={gray 0} font=" . $font;
    $p->create_field($llx, $lly, $urx, $ury, "date", "textfield", $optlist);

    $lly-=100; $ury-=100;
    $p->fit_textline("Name: ", 125, $lly+5, "position={right bottom}");

    $optlist = "tooltip={Enter your name here} " .
	"bordercolor={gray 0} font=" . $font;
    $p->create_field($llx, $lly, $urx, $ury, "name", "textfield", $optlist);

    $p->end_page_ext("");

    $p->end_document("");

};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
