#!/usr/bin/python
# $Id: starter_tagged.py,v 1.7.2.1 2011/07/11 12:45:08 rjs Exp $
#
# Tagged PDF starter:
# Create document with structure information for reflow and accessibility
#
# required software: PDFlib/PDFlib+PDI/PPS 7
# required data: none (dummy text created in program)

from sys import exc_info
from traceback import print_tb
from PDFlib.PDFlib import *


# This is where the data files are. Adjust as necessary.
searchpath = "../data"
outfilename = "starter_tagged.pdf"

p = PDFlib()

try:
    # This means we must check return values of load_font() etc.
    p.set_parameter("errorpolicy", "return")

    p.set_parameter("SearchPath", searchpath)

    if (p.begin_document(outfilename, "tagged=true lang=en") == -1):
        raise PDFlibException("Error: " + p.get_errmsg())

    p.set_info("Creator", "PDFlib starter sample")
    p.set_info("Title", "starter_tagged")

    # Automatically create spaces between chunks of text
    p.set_parameter("autospace", "true")

    # open the first structure element as a child of the document
    # structure root (=0)

    id = p.begin_item("Document",
		"Title = {Starter sample for Tagged PDF}");

    p.begin_page_ext(0, 0,
	    "width=a4.width height=a4.height taborder=structure");

    p.create_bookmark("Section 1", "");

    font = p.load_font("Helvetica", "winansi", "")
    if font == -1:
        raise PDFlibException("Error: " + p.get_errmsg())

    p.setfont(font, 24.0)

    id2 = p.begin_item("H1", "Title = {Introduction}");
    p.show_xy("1 Introduction", 50, 700);
    p.end_item(id2);

    id2 = p.begin_item("P", "Title = {Simple paragraph}");
    p.setfont(font, 12.0);
    p.continue_text("This PDF has a very simple document structure ");
    p.continue_text("which demonstrates basic Tagged PDF features ");
    p.continue_text("for accessibility.");

    p.end_item(id2);

    # The page number is created as an artifact; it will be
    # ignored when reflowing the page in Acrobat.

    id_artifact = p.begin_item("Artifact", "")
    p.show_xy("Page 1", 250, 100)
    p.end_item(id_artifact)

    p.end_page_ext("")

    p.end_item(id)
    p.end_document("")

except PDFlibException:
    print("PDFlib exception occurred:\n[%d] %s: %s" %
	((p.get_errnum()), p.get_apiname(),  p.get_errmsg()))
    print_tb(exc_info()[2])

except Exception:
    print("Exception occurred: %s" % (exc_info()[0]))
    print_tb(exc_info()[2])

finally:
    p.delete()
