' PDFlib client: fill Blocks with PPS to create a business card
' Required software: PDFlib Personalization Server (PPS)
'

Imports System
Imports System.Text
Imports PDFlib_dotnet

Structure blockdata
    Public name, value As String

    ' Constructor:
    Public Sub New(ByVal s_name As String, ByVal s_value As String)
        name = s_name
        value = s_value
    End Sub

End Structure

Class businesscard
    Public Shared Sub Main()
        Dim p As PDFlib_dotnet.PDFlib = Nothing
        Dim i, blockcontainer, page, pagecount, pageno As Integer
        Dim infile As String
        Dim searchpath, fontpath As String
        Dim dataset(7) As blockdata
        Dim BLOCKCOUNT As Integer

        dataset(0) = New blockdata("name",                     "Victor Kraxi")
        dataset(1) = New blockdata("business.title",           "Chief Paper Officer")
        dataset(2) = New blockdata("business.address.line1",   "17, Aviation Road")
        dataset(3) = New blockdata("business.address.city",    "Paperfield")
        dataset(4) = New blockdata("business.telephone.voice", "phone +1 234 567-89")
        dataset(5) = New blockdata("business.telephone.fax",   "fax +1 234 567-98")
        dataset(6) = New blockdata("business.email",           "victor@kraxi.com")
        dataset(7) = New blockdata("business.homepage",        "www.kraxi.com")

        BLOCKCOUNT = dataset.Length

        infile = "boilerplate.pdf"
        ' This is where font/image/PDF input files live. Adjust as necessary.
        ' Note that this directory must also contain the font files.
        '
        searchpath = "../../../data"
        ' By default annotations are also imported. In some cases this
        ' requires the Noto fonts for creating annotation appearance streams.
        ' We therefore set the searchpath to also point to the font directory.
        '
        fontpath = "../../../../resource/font"

        Try
            p = New PDFlib()

            ' This means we must check return values of load_font() etc.
            ' Set the search path for fonts and PDF files 
            p.set_option("errorpolicy=return SearchPath={{" + searchpath + "}}")

            p.set_option("SearchPath={{" + fontpath + "}}")


            If (p.begin_document("businesscard.pdf", "") = -1) Then
                Console.WriteLine("Error: {0}", p.get_errmsg())
                End
            End If

            p.set_info("Creator", "businesscard")
            p.set_info("Author", "Thomas Merz")
            p.set_info("Title", "PDFlib Block processing sample")

            blockcontainer = p.open_pdi_document(infile, "")
            If (blockcontainer = -1) Then
                Console.WriteLine("Couldn't open input file {0}.", infile)
                End
            End If

            pagecount = CInt(p.pcos_get_number(blockcontainer, "length:pages"))

            For pageno = 1 to pagecount Step 1

                page = p.open_pdi_page(blockcontainer, pageno, "")

                If (page = -1) Then
                    Console.WriteLine("Couldn't open page 1 in {0}.", infile)
                    End
                End If

                p.begin_page_ext(20, 20, "")   ' dummy page size

                ' This will adjust the page size to the size of the input page
                p.fit_pdi_page(page, 0, 0, "adjustpage")

                ' Fill all text Blocks with dynamic data
                For i = 0 To (BLOCKCOUNT - 1) Step 1
                    If (p.fill_textblock(page, dataset(i).name, dataset(i).value, "") = -1) Then
                        Console.WriteLine("Warning: couldn't fill block {0} in {1}", dataset(i).name, infile)
                    End If
                Next

                p.end_page_ext("")
                p.close_pdi_page(page)
            Next

            p.end_document("")
            p.close_pdi_document(blockcontainer)

        Catch e As PDFlibException
            ' caught exception thrown by PDFlib
            Console.WriteLine("PDFlib exception occurred in businesscard sample:")
            Console.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)

        Finally
            If Not p Is Nothing Then
                p.Dispose()
            End If
        End Try

    End Sub
End Class
