' PDFlib client: hello example in VB.NET
'

Imports System
Imports System.Text
Imports PDFlib_dotnet

Class hello
    Public Shared Sub Main()
        Dim p As PDFlib_dotnet.PDFlib = Nothing
        Dim searchpath As String = "../../../data/"

        Try
            p = New PDFlib()

            ' This means we must check return values of load_font() etc.
            p.set_option("errorpolicy=return")

            ' Set the search path for font files */
            p.set_option("SearchPath={{" + searchpath + "}}")


            If (p.begin_document("hello.pdf", "") = -1) Then
                Console.WriteLine("Error: {0}", p.get_errmsg())
                End
            End If

            p.set_info("Creator", "hello.vb")
            p.set_info("Author", "Rainer Schaaf")
            p.set_info("Title", "Hello World (VB.NET)!")

            ' start a new page
            p.begin_page_ext(0,0, "width=a4.width height=a4.height")

            Dim fontopt As String =
                "fontname=NotoSerif-Regular fontsize=24"

            p.fit_textline("Hello world!", 50, 700, fontopt)
            p.fit_textline("(says .NET/VB)", 50, 676, fontopt)

            p.end_page_ext("")
            p.end_document("")

        Catch e As PDFlibException
            Console.WriteLine("PDFlib exception occurred in hello sample:")
            Console.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)

        Finally
            If Not p Is Nothing Then
                p.Dispose()
            End If
        End Try

    End Sub
End Class
