' PDFlib client: image example in vb.NET
'

Imports System
Imports System.Text
Imports PDFlib_dotnet

Class image
    Public Shared Sub Main()
        Dim p As PDFlib_dotnet.PDFlib = Nothing
        Dim image As Integer
        Dim imagefile As String
        ' This is where font/image/PDF input files live. Adjust as necessary.
        Dim searchpath As String

        imagefile = "nesrin.jpg"
        searchpath = "../../../data"

        Try
            p = New PDFlib()

            ' This means we must check return values of load_image() etc.
            p.set_option("errorpolicy=return")

            ' Set the search path for fonts and PDF files 
            p.set_option("SearchPath={{" + searchpath + "}}")

            If (p.begin_document("image.pdf", "") = -1) Then
                Console.WriteLine("Error: {0}", p.get_errmsg())
                End
            End If

            p.set_info("Creator", "image")
            p.set_info("Author", "Thomas Merz")
            p.set_info("Title", "image sample")

            image = p.load_image("auto", imagefile, "")

            If image = -1 Then
                Console.WriteLine("Error: {0}", p.get_errmsg())
                End
            End If

            ' dummy page size, will be adjusted by p.fit_image() 
            p.begin_page_ext(0, 0, "width=a4.width height=a4.height")
            p.fit_image(image, 0.0, 0.0, "adjustpage")
            p.close_image(image)

            p.end_page_ext("")

            p.end_document("")

        Catch e As PDFlibException
            ' caught exception thrown by pdflib
            Console.WriteLine("PDFlib exception occurred in image sample:")
            Console.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)

        Finally
            If Not p Is Nothing Then
                p.Dispose()
            End If
        End Try

    End Sub
End Class
