' 
' Starter sample for fallback fonts
'
' Required data: suitable fonts
'

Imports System
Imports System.Text
Imports PDFlib_dotnet

Structure testcase
    Public usecase As String
    Public fontname As String
    Public fallbackoptions As String
    Public text As String
    ' Constructor
    Public Sub New(ByVal s_usecase As String, ByVal s_fontname As String, _
                ByVal s_fallbackoptions As String, ByVal s_text As String)
        usecase = s_usecase
        fontname = s_fontname
        fallbackoptions = s_fallbackoptions
        text = s_text
    End Sub
End Structure

Module starter_fallback
  Sub Main()
        ' This is where the data files are. Adjust as necessary.
        Dim searchpath As String = "../../../data"
        Dim outfile As String = "starter_fallback.pdf"

        Dim optlist As New StringBuilder()
        Dim p As PDFlib = Nothing
        Dim row, col, table, test As Integer
        Dim llx As Double = 30
        Dim lly As Double = 50
        Dim urx As Double = 800
        Dim ury As Double = 570
        Dim result As String

        Dim header() As String = { _
            "Use case", _
            "Option list for the 'fallbackfonts' option", _
            "Base font", _
            "With fallback font" _
        }
        Dim MAXCOL As Integer = header.Length

        Dim testcases() As testcase = { _
           New testcase("Add enlarged pictogram", _
           "NotoSerif-Regular", _
           "{fontname=ZapfDingbats forcechars=U+261E " & _
           "fontsize=150% textrise=-15%}", _
           "hand symbol: &#x261E;"), _
           New testcase("Add enlarged symbol glyph", _
           "NotoSerif-Regular", _
           "{fontname=Symbol forcechars=U+2663 fontsize=125%}", _
            "club symbol: &#x2663;"), _
           New testcase("Add Hebrew characters to Latin font", _
           "NotoSerif-Regular", _
           "{fontname=NotoSerifHebrew-Regular}", _
            "Hebrew: &#x05D0;")
        }
    Dim n_testcases As Integer = testcases.Length

    Try
        ' create a new PDFlib object
        p = new PDFlib()

        ' This means that formatting and other errors will raise an
        ' exception. This simplifies our sample code, but is not
        ' recommended for production code.
        '/
	p.set_option("errorpolicy=exception")

	' Set the search path for fonts and PDF files 
            p.set_option("SearchPath={{" + searchpath + "}} charref=true glyphcheck=replace")


        ' Set an output path according to the name of the topic
        if (p.begin_document(outfile, "") = -1) Then
            Console.WriteLine("Error: {0}\n", p.get_errmsg())
            return
        End If

        p.set_info("Creator", "PDFlib starter sample")
        p.set_info("Title", "starter_fallback")

        ' Start Page
        p.begin_page_ext(0, 0, "width=a4.height height=a4.width")

        table = -1

        ' Table header
        row = 1
        For col=1 To MAXCOL Step 1
            optlist.Length = 0
            optlist.Append("fittextline={fontname=NotoSerif-Regular " & _
                "fontsize=10} margin=4")
            table = p.add_table_cell(table, col, row, header(col-1), _
                    optlist.ToString())
        Next

        ' Create fallback samples, one use case per row

            For test = 0 To n_testcases - 1 Step 1
                row = test + 2
                col = 1

                ' Column 1: description of the use case
                optlist.Length = 0
                optlist.Append("fittextline={fontname=NotoSerif-Regular " & _
                        "fontsize=10} margin=4")
                table = p.add_table_cell(table, col, row, _
                    testcases(test).usecase, optlist.ToString())
                col = col + 1

                ' Column 2: reproduce option list literally
                optlist.Length = 0
                optlist.Append("fittextline={fontname=NotoSerif-Regular " & _
                        "fontsize=10} margin=4")
                table = p.add_table_cell(table, col, row, _
                    testcases(test).fallbackoptions, optlist.ToString())
                col = col + 1

                ' Column 3: text with base font
                optlist.Length = 0
                optlist.Append("fittextline={fontname=")
                optlist.AppendFormat("{0}", testcases(test).fontname)
                optlist.Append("")
                optlist.Append(" fontsize=10 replacementchar=? } margin=4")
                table = p.add_table_cell(table, col, row, _
                        testcases(test).text, optlist.ToString())
                col = col + 1

                ' Column 4: text with base font and fallback fonts
                optlist.Length = 0
                optlist.Append("fittextline={fontname=")
                optlist.AppendFormat("{0}", testcases(test).fontname)
                optlist.Append("")
                optlist.Append(" fontsize=10 fallbackfonts={")
                optlist.AppendFormat("{0}", testcases(test).fallbackoptions)
                optlist.Append("}} margin=4")
                table = p.add_table_cell(table, col, row, _
                   testcases(test).text, optlist.ToString())
                col = col + 1
            Next

        ' Place the table
        optlist.Length = 0
        optlist.Append("header=1 fill={{area=rowodd " & _
            "fillcolor={gray 0.9}}} stroke={{line=other}} ")
        result = p.fit_table(table, llx, lly, urx, ury, optlist.ToString())

        if (result = "_error") Then
            Console.WriteLine("Couldn't place table: {0}\n",p.get_errmsg())
            return
        End If

        p.end_page_ext("")
        p.end_document("")

    Catch e As PDFlibException
        Console.Error.WriteLine("PDFlib exception occurred:")
        Console.Error.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)
    Catch e As System.Exception
        Console.Error.WriteLine(e.ToString())
    Finally
        If Not p Is Nothing Then
            p.Dispose()
            p = Nothing
        End If
    End Try
  End Sub
End Module
