' 
'
' formfields starter:
' create a linearized PDF (for fast delivery over the Web, also known
' as "fast Web view") which is encrypted and contains some form fields.
' A few lines of JavaScript are inserted as "page open" action to
' automatically populate the date field with the current date.
'
' Required data: font file
' 
Imports System
Imports System.Text
Imports PDFlib_dotnet

Module starter_formfields

    Sub Main()
        ' This is where the data files are. Adjust as necessary.'
        Const searchpath As String = "../../../data"

        Dim p As PDFlib_dotnet.PDFlib = Nothing
        Dim optlist As String
        Dim font, action As Integer
        Dim llx As Double = 150, lly As Double = 550
        Dim urx As Double = 350, ury As Double = 575

        ' JavaScript for automatically filling the date into a form field
        Const js As String = _
            "var d = util.printd(""mm/dd/yyyy"", new Date());" & _
            "var date = this.getField(""date"");" & _
            "date.value = d;"

        Try
            p = New PDFlib()

            ' This means we must check return values of load_font() etc.
            p.set_option("errorpolicy=return")

            ' Set the search path for fonts and PDF files 
            p.set_option("SearchPath={{" + searchpath + "}}")

            ' Prevent changes with a master password
            optlist = "linearize masterpassword=pdflib permissions={nomodify}"

            If p.begin_document("starter_formfields.pdf", optlist) = -1 Then
                Console.WriteLine("Error: " & p.get_errmsg())
                Return
            End If

            p.set_info("Creator", "PDFlib starter sample")
            p.set_info("Title", "starter_formfields")

            optlist = "script[" & js.Length & "]={" & js & "}"
            action = p.create_action("JavaScript", optlist)

            optlist = "width=a4.width height=a4.height action={open=" & action & "}"
            p.begin_page_ext(0, 0, optlist)

            font = p.load_font("NotoSerif-Regular", "winansi", "simplefont nosubsetting")

            If font = -1 Then
                Console.WriteLine("Error: " & p.get_errmsg())
                Return
            End If

            p.setfont(font, 24)

            p.fit_textline("Date: ", 125, lly + 5, "position={right bottom}")

            ' The tooltip will be used as rollover text for the field
            optlist = _
                "tooltip={Date (will be filled automatically)} " & _
                "bordercolor={gray 0} font=" & font
            p.create_field(llx, lly, urx, ury, "date", "textfield", optlist)

            lly = lly - 100
            ury = ury - 100
            p.fit_textline("Name: ", 125, lly + 5, "position={right bottom}")

            optlist = _
                "tooltip={Enter your name here} " & _
                "bordercolor={gray 0} font=" & font
            p.create_field(llx, lly, urx, ury, "name", "textfield", optlist)

            p.end_page_ext("")

            p.end_document("")

        Catch e As PDFlibException
            Console.Error.WriteLine("PDFlib exception occurred:")
            Console.Error.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)
        Catch e As System.Exception
            Console.Error.WriteLine(e.ToString())
        Finally
            If Not p Is Nothing Then
                p.Dispose()
                p = Nothing
            End If
        End Try

    End Sub

End Module
