' 
' Starter layer:
' Define several layers, output images and text to them and define
' particular layers to be visible when opening the document
'
' Define two layers for RGB or Grayscale images and two layers for English or
' German image captions. Output images and text on the various layers and
' open the document with the RGB images and English captions visible.
'
' Required data: grayscale and RGB images
'


Imports System
Imports System.Text
Imports PDFlib_dotnet


Module starter_layer
    Sub Main()
        ' This is where the data files are. Adjust as necessary.'
        Const searchpath As String = "../../../data"
        Dim outfile As String = "starter_layer.pdf"

        Dim p As PDFlib_dotnet.PDFlib = Nothing
        Const rgb As String = "nesrin.jpg"
        Const gray As String = "nesrin_gray.jpg"
        Dim optlist As New StringBuilder

        try 
            p = new PDFlib()

            Dim font, imageRGB, imageGray, layerRGB, layerGray, layerEN, layerDE As Integer
            ' This means we must check return values of load_font() etc.
	    p.set_option("errorpolicy=return")

	    ' Set the search path for fonts and PDF files 
	    p.set_option("SearchPath={{" + searchpath + "}}")

            ' Open the document with the "Layers" navigation tab visible'
            if (p.begin_document(outfile, "openmode=layers") = -1) Then
                Console.WriteLine("Error: " & p.get_errmsg())
                return
            End If

            p.set_info("Creator", "PDFlib starter sample")
            p.set_info("Title", "starter_layer")


            ' Load the font'
            font = p.load_font("NotoSerif-Regular", "unicode", "")

            if (font = -1) Then
                Console.WriteLine("Error: " & p.get_errmsg())
                return
            End If

            ' Load the Grayscale image'
            imageGray = p.load_image("auto", gray, "")
            if (imageGray = -1) Then
                Console.WriteLine("Error: " & p.get_errmsg())
                return
            End If

            ' Load the RGB image'
            imageRGB = p.load_image("auto", rgb, "")
            if (imageRGB = -1) Then
                Console.WriteLine("Error: " & p.get_errmsg())
                return
            End If

            '
            ' Define all layers which will be used, and their relationships.
            ' This should be done before the first page if the layers are
            ' used on more than one page.
            '

            ' Define the layer "RGB"'
            layerRGB = p.define_layer("RGB", "")

            ' Define the layer "Grayscale" which is hidden when opening the
            ' document or printing it.
            '
            optlist.Length = 0
            optlist.AppendFormat("initialviewstate=false initialprintstate=false")
            layerGray = p.define_layer("Grayscale", optlist.ToString())

            ' At most one of the "Grayscale" and "RGB" layers should be visible'
            optlist.Length = 0
            optlist.AppendFormat("group={{{0} {1}}}", layerGray, layerRGB)
            p.set_layer_dependency("Radiobtn", optlist.ToString())

            ' Define the layer "English"'
            layerEN = p.define_layer("English", "")

            ' Define the layer "German" which is hidden when opening the document
            ' or printing it.
            '
            layerDE = p.define_layer("German", "initialviewstate=false initialprintstate=false")

            ' At most one of the "English" and "German" layers should be visible
            optlist.Length = 0
            optlist.AppendFormat("group={{{0} {1}}}", layerEN, layerDE)
            p.set_layer_dependency("Radiobtn", optlist.ToString())

            ' Start page'
            p.begin_page_ext(0, 0, "width=a4.width height=a4.height")

            ' Place the RGB image on the layer "RGB"'
            p.begin_layer(layerRGB)
            p.fit_image(imageRGB, 100, 400, "boxsize={400 300} fitmethod=meet")

            ' Place the Grayscale image on the layer "Grayscale"'
            p.begin_layer(layerGray)
            p.fit_image(imageGray, 100, 400, "boxsize={400 300} fitmethod=meet")

            ' Place an English image caption on the layer "English"'
            optlist.Length = 0
            optlist.AppendFormat("font={0} fontsize=20", font)
            p.begin_layer(layerEN)
            p.fit_textline("This is the Nesrin image.", 100, 370, optlist.ToString())

            ' Place a German image caption on the layer "German". '
            optlist.Length = 0
            optlist.AppendFormat("font={0} fontsize=20", font)
            p.begin_layer(layerDE)
            p.fit_textline("Das ist das Nesrin-Bild.", 100, 370, optlist.ToString())

            p.end_layer()

            p.end_page_ext("")

            p.end_document("")

        Catch e As PDFlibException
            Console.Error.WriteLine("PDFlib exception occurred:")
            Console.Error.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)
        Catch e As System.Exception
            Console.Error.WriteLine(e.ToString())
        Finally
            If Not p Is Nothing Then
                p.Dispose()
                p = Nothing
            End If
        End Try

    End Sub

End Module
