' 
' Starter sample for path objects:
' Create some basic examples of path object construction and use
'
' Required data: font
'


Imports System
Imports System.Text
Imports PDFlib_dotnet


Module starter_path
    Sub main()
        Dim outfile As String
        outfile = "starter_path.pdf"

        ' This is where the data files are. Adjust as necessary.
        Dim searchpath As String = "../../../data"

        Dim path, tf, n As Integer
        Dim result As String
        Dim x, y As Double
        Dim optlist, text As String
        text = _
    "Lorem ipsum dolor sit amet, consectetur adipisicing elit, " + _
    "sed do eiusmod tempor incididunt ut labore et dolore magna " + _
    "aliqua. Ut enim ad minim veniam, quis nostrud exercitation " + _
    "ullamco laboris nisi ut aliquip ex ea commodo consequat. " + _
    "Duis aute irure dolor in reprehenderit in voluptate velit esse cillum " + _
    "dolore eu fugiat nulla pariatur. Excepteur sint occaecat " + _
    "cupidatat non proident, sunt in culpa qui officia deserunt mollit anim " + _
    "id est laborum. "

        Dim p As PDFlib_dotnet.PDFlib = Nothing

        try
            ' create a new PDFlib object
            p = new PDFlib()

            ' This means we must check return values of load_font() etc.
            p.set_option("errorpolicy=return")

            ' Set the search path for fonts and PDF files 
            p.set_option("SearchPath={{" + searchpath + "}}")

            If p.begin_document(outfile, "") = -1 Then
                Console.WriteLine("Error: " & p.get_errmsg())
                return
            End If

            p.set_info("Creator", "PDFlib starter sample")
            p.set_info("Title", "starter_path")

            ' Start an A4 page
            p.begin_page_ext(0, 0, "width=a4.width height=a4.height")

            ' Construct a path object for an arrow shape

            path = -1

            ' The tip of the arrow gets rounded corners
            path = p.add_path_point(path, 200, 25, "move", "round=10")
            path = p.add_path_point(path, 200, 75, "line", "")

            ' assign a name to the arrow's tip
            path = p.add_path_point(path, 300, 0, "line", "name=tip")
            path = p.add_path_point(path, 200, -75, "line", "")
            path = p.add_path_point(path, 200, -25, "line", "")

            ' Start a new subpath for the straight base of the arrow
            path = p.add_path_point(path, 200, -25, "move", "")
            path = p.add_path_point(path, 0, -25, "line", "")

            ' The center of the base can serve as a named attachment point
            path = p.add_path_point(path, 0, 0, "line", "name=base")
            path = p.add_path_point(path, 0, 25, "line", "")
            path = p.add_path_point(path, 200, 25, "line", "")

            x = 100
            y = 850


            ' ----------------------------------------
            ' Place arrow in its original direction
            ' ----------------------------------------
            '
            y = y - 100
            p.draw_path(path, x, y, _
                "stroke linewidth=3 fill fillcolor=Turquoise " & _
                "linecap=projecting attachmentpoint=base ")


            ' ----------------------------------------
            ' Scale down arrow and align it to north east
            ' ----------------------------------------
            '
            y = y - 200
            p.draw_path(path, x, y, _
                "stroke linewidth=3 fill fillcolor=Turquoise " & _
                "linecap=projecting attachmentpoint=base scale=0.5 align={1 1}")


            ' ----------------------------------------
            ' Scale to 50%, use the arrow tip as attachment point,
            ' and align the arrow to the left
            ' ----------------------------------------
            '
            y = y - 100
            p.draw_path(path, x, y, _
                "stroke linewidth=3 fill fillcolor=Turquoise " & _
                "linecap=projecting attachmentpoint=tip scale=0.5 align={-1 0}")


            ' ----------------------------------------
            ' Place text on the path round all corners to
            ' allow smoother text at the corners
            ' ----------------------------------------
            '
            y = y - 100
            optlist = "textpath={path=" & path & " round=10} position={center bottom} " & _
                "fontname=NotoSerif-Regular encoding=winansi fontsize=8"
            p.fit_textline(text, x, y, optlist)


            ' ----------------------------------------
            ' Use the path as clipping path for a Textflow
            ' ----------------------------------------
            '
            y = y - 300

            ' Feed the text to the Textflow object
            tf = p.add_textflow(-1, text, _
                "fontname=NotoSerif-Regular fontsize=10 encoding=winansi alignment=justify")
            ' Use text twice to fill the arrow
            tf = p.add_textflow(tf, text, _
                "fontname=NotoSerif-Regular fontsize=10 encoding=winansi alignment=justify")

            If tf = -1 Then
                Console.WriteLine("Error: " & p.get_errmsg())
                return
            End If

            ' Attach the path's reference point to the middle left (0%, 50%)
            ' of the fitbox, and wrap the text inside the path (inversefill)
            '
            optlist = "wrap={inversefill paths={{path=" & path & _
                " refpoint={0% 50%} scale=1.5 }}}"
            result = p.fit_textflow(tf, x, y, x + 450, y + 225, optlist)

            If result <> "_stop" Then
                ' In this example we don't care about overflow text
            End If
            p.delete_textflow(tf)


            ' ----------------------------------------
            ' Query information about the path object
            ' ----------------------------------------
            '
            n = p.info_path(path, "numpoints", "")


            p.delete_path(path)
            p.end_page_ext("")
            p.end_document("")

        Catch e As PDFlibException
            Console.Error.WriteLine("PDFlib exception occurred:")
            Console.Error.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)
        Catch e As System.Exception
            Console.Error.WriteLine(e.ToString())
        Finally
            If Not p Is Nothing Then
                p.Dispose()
                p = Nothing
            End If
        End Try

    End Sub

End Module
