'
' pCOS starter:
' Dump information from an existing PDF document
'
' Required software: PDFlib+PDI or PDFlib Personalization Server (PPS)
' Required data: PDF input file
'
Imports System
Imports System.Text
Imports PDFlib_dotnet

Module starter_pcos

    Sub Main()
        ' This is where the data files are. Adjust as necessary.
        Dim searchpath As String = "../../../data"

        Dim p As PDFlib_dotnet.PDFlib = Nothing

        Const pdfinput As String = "pCOS-datasheet.pdf"

        Const docoptlist As String = "requiredmode=minimum"
        Dim count As Integer
	Dim pcosmode As String
        Dim i, doc As Integer
        Dim objtype As String
        Dim xfa_present, plainmetadata As Boolean

        Try
            p = New PDFlib()

            ' This means we must check return values of load_font() etc.
	    p.set_option("errorpolicy=return")

	    ' Set the search path for fonts and PDF files 
	    p.set_option("SearchPath={{" + searchpath + "}}")

            ' We do not create any output document, so no call to
            ' begin_document() is required.


            ' Open the input document
            doc = p.open_pdi_document(pdfinput, docoptlist)
            If doc = -1 Then
                Console.WriteLine("Error: " & p.get_errmsg())
                p.Dispose()
                System.Environment.Exit(1)
            End If

            ' --------- general information (always available)
            pcosmode = p.pcos_get_string(doc, "pcosmodename")

            Console.WriteLine("   File name: " & _
                        p.pcos_get_string(doc, "filename"))

            Console.WriteLine(" PDF version: " & _
                        p.pcos_get_string(doc, "pdfversionstring"))

            Console.WriteLine("  Encryption: " & _
                        p.pcos_get_string(doc, "encrypt/description"))

            If p.pcos_get_number(doc, "encrypt/master") <> 0 Then
                Console.WriteLine("   Master pw: yes")
            Else
                Console.WriteLine("   Master pw: no")
            End If

            If p.pcos_get_number(doc, "encrypt/user") <> 0 Then
                Console.WriteLine("     User pw: yes")
            Else
                Console.WriteLine("     User pw: no")
            End If

            If p.pcos_get_number(doc, "encrypt/nocopy") <> 0 Then
                Console.WriteLine("Text copying: no")
            Else
                Console.WriteLine("Text copying: yes")
            End If

            If p.pcos_get_number(doc, "linearized") <> 0 Then
                Console.WriteLine("  Linearized: yes")
            Else
                Console.WriteLine("  Linearized: no")
            End If

            Console.WriteLine()

            If pcosmode = "minimum" Then
                Console.WriteLine("Minimum mode: no more information available")
                p.Dispose()
                System.Environment.Exit(0)
            End If

            ' --------- more details (requires at least user password)
            Console.WriteLine("PDF/X status: " & p.pcos_get_string(doc, "pdfx"))

            Console.WriteLine("PDF/A status: " & p.pcos_get_string(doc, "pdfa"))

            xfa_present = p.pcos_get_string(doc, "type:/Root/AcroForm/XFA") <> "null"
            If xfa_present Then
                Console.WriteLine("    XFA data: yes")
            Else
                Console.WriteLine("    XFA data: no")
            End If

            If p.pcos_get_number(doc, "tagged") <> 0 Then
                Console.WriteLine("  Tagged PDF: yes")
            Else
                Console.WriteLine("  Tagged PDF: no")
            End If

            Console.WriteLine("No. of pages: " & _
                        p.pcos_get_number(doc, "length:pages"))

            Console.WriteLine(" Page 1 size: width={0:0.000}, height={1:0.000}", _
             p.pcos_get_number(doc, "pages[0]/width"), _
             p.pcos_get_number(doc, "pages[0]/height"))

            count = p.pcos_get_number(doc, "length:fonts")
            Console.WriteLine("No. of fonts: " & count)

            For i = 0 To count - 1
                Dim fonts As String = "fonts[" & i & "]/embedded"

                If p.pcos_get_number(doc, fonts) <> 0 Then
                    Console.Write("embedded ")
                Else
                    Console.Write("unembedded ")
                End If

                fonts = "fonts[" & i & "]/type"
                Console.Write(p.pcos_get_string(doc, fonts) & " font ")
                fonts = "fonts[" & i & "]/name"
                Console.WriteLine(p.pcos_get_string(doc, fonts))
            Next i

            Console.WriteLine()

            plainmetadata = p.pcos_get_number(doc, "encrypt/plainmetadata") <> 0

            If pcosmode = "restricted" And Not plainmetadata _
                    And p.pcos_get_number(doc, "encrypt/nocopy") <> 0 Then
                Console.Write( _
                    "Restricted mode: no more information available")
                p.Dispose()
                System.Environment.Exit(0)
            End If


            ' ----- document info keys and XMP metadata (requires master pw)

            count = p.pcos_get_number(doc, "length:/Info")

            For i = 0 To count - 1
                Dim info As String
                Dim key As String
                Dim len As Integer

                info = "type:/Info[" & i & "]"
                objtype = p.pcos_get_string(doc, info)

                info = "/Info[" & i & "].key"
                key = p.pcos_get_string(doc, info)
                len = 12 - key.Length
                While len > 0
                    Console.Write(" ")
                    len = len - 1
                End While

                Console.Write(key & ": ")

                ' Info entries can be stored as string or name objects
                If objtype = "name" Or objtype = "string" Then
                    info = "/Info[" & i & "]"
                    Console.WriteLine("'" & p.pcos_get_string(doc, info) & _
                            "'")
                Else
                    info = "type:/Info[" & i & "]"
                    Console.WriteLine("(" & p.pcos_get_string(doc, info) & _
                            " object)")
                End If
            Next i


            Console.WriteLine()
            Console.Write("XMP meta data: ")


            objtype = p.pcos_get_string(doc, "type:/Root/Metadata")
            If objtype = "stream" Then
                Dim contents() As Byte
                Dim ustring as String

                contents = p.pcos_get_stream(doc, "", "/Root/Metadata")
                                ' This demonstrates Unicode conversion
                ustring = p.convert_to_unicode("utf8", contents, "outputformat=utf16")

                Console.WriteLine("(" & ustring.Length & " Unicode code points)")
            Else
                Console.WriteLine("not present")
            End If

            p.close_pdi_document(doc)

        Catch e As PDFlibException
            Console.Error.WriteLine("PDFlib exception occurred:")
            Console.Error.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)
        Catch e As System.Exception
            Console.Error.WriteLine(e.ToString())
        Finally
            If Not p Is Nothing Then
                p.Dispose()
                p = Nothing
            End If
        End Try

    End Sub

End Module
