'
' PDF/A-1b starter:
' Create PDF/A-1b conforming output
'
' Required data: font file, image file
'
Imports System
Imports System.Text
Imports PDFlib_dotnet

Module starter_pdfa1b

    Sub Main()
        ' This is where the data files are. Adjust as necessary.
        Const searchpath As String = "../../../data"

        Dim p As PDFlib_dotnet.PDFlib = Nothing
        Const imagefile As String = "nesrin.jpg"

        Dim image As Integer

        Try
            p = New PDFlib()

            ' This means we must check return values of load_font() etc.
            p.set_option("errorpolicy=return")

            ' Set the search path for fonts and PDF files 
            p.set_option("SearchPath={{" + searchpath + "}}")

            ' PDF/A-1a requires Tagged PDF
            If p.begin_document("starter_pdfa1b.pdf", "pdfa=PDF/A-1b:2005") _
                                        = -1 Then
                Console.WriteLine("Error: " & p.get_errmsg())
                return
            End If

            p.set_info("Creator", "PDFlib starter sample")
            p.set_info("Title", "starter_pdfa1b")

            p.begin_page_ext(0,0, "width=a4.width height=a4.height")

            p.fit_textline("PDF/A-1b:2005 starter", 50, 700, _
                "fontname=NotoSerif-Regular fontsize=24")

            ' Load an RGB image

            image = p.load_image("auto", imagefile, "")

            If image = -1 Then
                Console.WriteLine("Error: " & p.get_errmsg())
                return
            End If

            ' Place the image at the bottom of the page
            p.fit_image(image, 0.0, 0.0, "scale=0.5")

            p.end_page_ext("")
            p.close_image(image)

            p.end_document("")

        Catch e As PDFlibException
            Console.Error.WriteLine("PDFlib exception occurred:")
            Console.Error.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)
        Catch e As System.Exception
            Console.Error.WriteLine(e.ToString())
        Finally
            If Not p Is Nothing Then
                p.Dispose()
                p = Nothing
            End If
        End Try

    End Sub

End Module
