' 
' PDF merge starter:
' Merge pages from multiple PDF documents (including annotations)
'
' Required software: PDFlib+PDI or PDFlib Personalization Server (PPS)
' Required data: PDF documents
'
Imports System
Imports System.Text
Imports PDFlib_dotnet

Module starter_pdfmerge

    Sub Main()
        ' This is where the data files are. Adjust as necessary.
        Const searchpath As String = "../../../data"
        ' By default annotations are also imported. In some cases this
        ' requires the Noto fonts for creating annotation appearance streams.
        ' We therefore set the searchpath to also point to the font directory.
        '
        Const fontpath = "../../../../resource/font"

        Dim p As PDFlib_dotnet.PDFlib = Nothing

        Dim pdffiles() As String = _
        { _
            "markup_annotations.pdf", _
            "pCOS-datasheet.pdf" _
        }
        Dim pdffile As String

        Try
            p = New PDFlib()

            ' This means we must check return values of load_font() etc.
            p.set_option("errorpolicy=return")

            ' Set the search path for fonts and PDF files 
            p.set_option("SearchPath={{" + searchpath + "}}")
            p.set_option("SearchPath={{" + fontpath + "}}")

            If p.begin_document("starter_pdfmerge.pdf", "") = -1 Then
                Console.WriteLine("Error: " & p.get_errmsg())
            End If

            p.set_info("Creator", "PDFlib starter sample")
            p.set_info("Title", "starter_pdfmerge")

            For Each pdffile In pdffiles
                Dim indoc, endpage, pageno, page As Integer

                ' Open the input PDF
                indoc = p.open_pdi_document(pdffile, "")
                If indoc = -1 Then
                    Console.Error.WriteLine("Error: " & p.get_errmsg())
                Else
                    endpage = CInt(p.pcos_get_number(indoc, "length:pages"))

                    ' Loop over all pages of the input document
                    For pageno = 1 To endpage
                        page = p.open_pdi_page(indoc, pageno, "")

                        If page = -1 Then
                            Console.Error.WriteLine("Error: " & p.get_errmsg())
                        Else
                            ' Dummy page size; will be adjusted later
                            p.begin_page_ext(10, 10, "")

                            ' Create a bookmark with the file name
                            If pageno = 1 Then
                                p.create_bookmark(pdffile, "")
                            End If

                            ' Place the imported page on the output page, and
                            ' adjust the page size. If the page contains annotations
                            ' these are also imported.
                            p.fit_pdi_page(page, 0, 0, "adjustpage")
                            p.close_pdi_page(page)

                            p.end_page_ext("")
                        End If
                    Next pageno
                End If
		p.close_pdi_document(indoc)
	        Next pdffile

            p.end_document("")

        Catch e As PDFlibException
            Console.Error.WriteLine("PDFlib exception occurred:")
            Console.Error.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)
        Catch e As System.Exception
            Console.Error.WriteLine(e.ToString())
        Finally
            If Not p Is Nothing Then
                p.Dispose()
                p = Nothing
            End If
        End Try

    End Sub

End Module
