' 
' PDF/UA-1 starter:
' Create PDF/UA-1 document with various content types including structure
' elements, artifacts, and interactive elements.
'
' Required data: font file, image
'
Imports System
Imports System.Text
Imports PDFlib_dotnet

Module starter_pdfua1

    Sub Main()
        ' This is where the data files are. Adjust as necessary.
        Const searchpath As String = "../../../data"
        Const imagefile As String = "lionel.jpg"
        Dim p As PDFlib_dotnet.PDFlib = Nothing
        Dim id, image, font, action As Integer
        Dim optlist As String


        Try
            p = New PDFlib()


            ' errorpolicy=exception means that the program will stop
            ' if one of the API function runs into a problem.

            p.set_option("errorpolicy=exception searchPath={{" & searchpath & "}}")

            p.begin_document("starter_pdfua1.pdf", _
            "pdfua=PDF/UA-1 lang=en " & _
            "tag={tagname=Document Title={PDFlib PDF/UA-1 demo}}")

            p.set_info("Creator", "starter_pdfua1")
            p.set_info("Title", "PDFlib PDF/UA-1 demo")

            ' Automatically create spaces between chunks of text 
            p.set_option("autospace=true")

            p.begin_page_ext(0, 0, _
             "width=a4.width height=a4.height taborder=structure")

            p.create_bookmark("PDF/UA-1 demo", "")

            font = p.load_font("NotoSerif-Regular", "unicode", "")

            p.setfont(font, 24.0)

            ' =================== Simple text  ========================

            ' Use abbreviated tagging with the "tag" option */
            p.fit_textline("Introduction to Paper Planes",
                50, 700, "tag={tagname=H1 Title={Introduction}} fontsize=24")

            p.fit_textline( _
                "Paper planes can be made from any kind of paper.", _
                50, 675, "tag={tagname=P} fontsize=12")

            p.fit_textline("Most paper planes don't have an engine.", _
                50, 650, "tag={tagname=P} fontsize=12")

            ' =================== Interactive Link ======================== 
            ' Open both P and Link elements in a single call
            id = p.begin_item("P", "tag={tagname=Link Title={Kraxi on the Web}}")

            ' Create visible content which represents the link */
            p.fit_textline("Learn more on the Kraxi website.", _
                 50, 625, _
                 "matchbox={name={kraxi.com}} fontsize=12 " & _
                 "strokecolor=blue fillcolor=blue underline")

            ' Create URI action 
            action = p.create_action("URI", "url={http://www.kraxi.com}")

            ' Create Link annotation on named matchbox "kraxi.com".
            ' This automatically creates an OBJR (object reference) element.

            optlist = "linewidth=0 usematchbox={kraxi.com} " & _
                "contents={Link to Kraxi Inc. Web site} " & _
                "action={activate=" & action & " } "
            p.create_annotation(0, 0, 0, 0, "Link", optlist)

            ' This closes the Link and P structure elements
            p.end_item(id)

            ' =================== Image  ======================== 
            ' A grouping element is required as container for Figure and Caption 
            id = p.begin_item("Sect", "")
            image = p.load_image("auto", imagefile, "")

            ' The "Placement" attribute is recommended for Figure elements
            ' as children of grouping elements.

            p.fit_image(image, 50, 400, _
                "tag={tagname=Figure Placement=Block Alt={Image of Kraxi waiting for customers.}} " & _
                "scale=0.5")
            p.close_image(image)

            ' Caption text below the image; Caption element follows Figure.
            ' Since Caption doesn't allow direct content in PDF 1.7 we create
            ' an additional P element.
            p.fit_textline("Kraxi waiting for customers.", _
                50, 375, _
                "tag={tagname=Caption tag={tagname=P}} fontsize=12 ")

            p.end_item(id)

            ' =================== Artifact  ======================== 
            p.fit_textline("Page 1", 250, 100, _
                "tag={tagname=Artifact} fontsize=12")

            p.end_page_ext("")

            p.end_document("")
        Catch e As PDFlibException
            Console.Error.WriteLine("PDFlib exception occurred:")
            Console.Error.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)
        Catch e As System.Exception
            Console.Error.WriteLine(e.ToString())
        Finally
            If Not p Is Nothing Then
                p.Dispose()
                p = Nothing
            End If
        End Try
    End Sub

End Module
