'
' PDF/X-3 starter:
' Create PDF/X-3 conforming output
'
' Required data: font file, image file, ICC profile
'                (see www.pdflib.com for output intent ICC profiles)
'
Imports System
Imports System.Text
Imports PDFlib_dotnet

Module starter_pdfx3

    Sub Main()
        ' This is where the data files are. Adjust as necessary.
        Const searchpath As String = "../../../data"

        Dim p As PDFlib_dotnet.PDFlib = Nothing

        Const imagefile As String = "nesrin.jpg"

        Dim font, image, spot As Integer

        Try
            p = New PDFlib()

            ' This means we must check return values of load_font() etc.
	    p.set_option("errorpolicy=return")

	    ' Set the search path for fonts and PDF files 
	    p.set_option("SearchPath={{" + searchpath + "}}")

            If p.begin_document("starter_pdfx3.pdf", "pdfx=PDF/X-3:2003") = -1 Then
                Console.WriteLine("Error: " & p.get_errmsg())
                return
            End If

            p.set_info("Creator", "PDFlib starter sample")
            p.set_info("Title", "starter_pdfx3")

            If p.load_iccprofile("ISOcoated_v2_eci.icc", "usage=outputintent") = -1 Then
                Console.Error.WriteLine("Error: " & p.get_errmsg())
                Console.Error.WriteLine("See www.pdflib.com for output intent ICC profiles.")
                p.Dispose()
                System.Environment.Exit(2)
            End If

            p.begin_page_ext(0,0, "width=a4.width height=a4.height")

            font = p.load_font("NotoSerif-Regular", "unicode", "")

            If font = -1 Then
                Console.WriteLine("Error: " & p.get_errmsg())
                return
            End If

            p.setfont(font, 24)

            spot = p.makespotcolor("PANTONE 123 C")
            p.setcolor("fill", "spot", spot, 1.0, 0.0, 0.0)
            p.fit_textline("PDF/X-3:2003 starter", 50, 700, "")

            image = p.load_image("auto", imagefile, "")

            If image = -1 Then
                Console.WriteLine("Error: " & p.get_errmsg())
                return
            End If

            p.fit_image(image, 0.0, 0.0, "scale=0.5")

            p.end_page_ext("")

            p.end_document("")

        Catch e As PDFlibException
            Console.Error.WriteLine("PDFlib exception occurred:")
            Console.Error.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)
        Catch e As System.Exception
            Console.Error.WriteLine(e.ToString())
        Finally
            If Not p Is Nothing Then
                p.Dispose()
                p = Nothing
            End If
        End Try

    End Sub

End Module
