'
' PDF/X-4 starter:
' Create PDF/X-4 conforming output with layers and transparency
'
' A low-level layer is created for each of several languages, as well
' as an image layer. 
'
' The document contains transparent text which is allowed in
' PDF/X-4, but not earlier PDF/X standards.
'
' Required data: font file, image file, ICC output intent profile
'                (see www.pdflib.com for output intent ICC profiles)
'

Imports System
Imports System.Text
Imports PDFlib_dotnet

Module starter_pdfx4
  Sub Main()
    ' This is where the data files are. Adjust as necessary.*/
    Dim searchpath As String = "../../../data"

    Dim p As PDFlib = Nothing
    Dim imagefile As String = "zebra.tif"
    Dim optlist As New StringBuilder

    Dim font, image As Integer
    Dim layer_english, layer_german, layer_french, layer_image As Integer
    Dim width, height As Double

    Try
        ' create a new PDFlib object
        p = New PDFlib()

        ' This means we must check return values of load_font() etc.
        p.set_option("errorpolicy=return")
        
        ' Set the search path for fonts and PDF files 
        p.set_option("SearchPath={{" + searchpath + "}}")

        if (p.begin_document("starter_pdfx4.pdf", "pdfx=PDF/X-4") = -1) Then
            Console.WriteLine("Error: {0}\n", p.get_errmsg())
            return
        End If

        p.set_info("Creator", "PDFlib starter sample")
        p.set_info("Title", "starter_pdfx4")


        if (p.load_iccprofile("ISOcoated_v2_eci.icc", "usage=outputintent") = -1) Then
            Console.WriteLine("Error: {0}\n", p.get_errmsg())
            Console.WriteLine("See www.pdflib.com for output intent ICC profiles.")
            return
        End If

        ' Define the layers; "defaultstate" specifies whether or not
        ' the layer is visible when the page is opened

        layer_english = p.define_layer("English text", "defaultstate=true")
        layer_german  = p.define_layer("German text", "defaultstate=false")
        layer_french  = p.define_layer("French text", "defaultstate=false")

        ' Define a radio button relationship for the language layers.
        optlist.Length = 0
        optlist.AppendFormat("group={{ {0} {1} {2}}}", _
                layer_english, layer_german, layer_french)
        p.set_layer_dependency("Radiobtn", optlist.ToString())

        layer_image   = p.define_layer("Images", "defaultstate=true")

        p.begin_page_ext(0,0, "width=a4.width height=a4.height")

        font = p.load_font("NotoSerif-Regular", "winansi", "")

        if (font = -1) Then
            Console.WriteLine("Error: {0}\n", p.get_errmsg())
            return
        End If

        p.setfont(font, 24)

        p.begin_layer(layer_english)

        p.fit_textline("PDF/X-4 starter sample with layers", 50, 700, "")

        p.begin_layer(layer_german)
        p.fit_textline("PDF/X-4 Starter-Beispiel mit Ebenen", 50, 700, "")

        p.begin_layer(layer_french)
        p.fit_textline("PDF/X-4 Starter exemple avec des calques", 50, 700, "")

        p.begin_layer(layer_image)

        image = p.load_image("auto", imagefile, "")
        if (image = -1) Then
            return
        End If

        ' Place the image on the page
        p.fit_image(image, 0.0, 0.0, "")

        ' Place a diagonal stamp across the image area
        width = p.info_image(image, "width", "")
        height = p.info_image(image, "height", "")

        optlist.Length = 0
        optlist.Append("boxsize={")
        optlist.AppendFormat("{0} {1}", width, height)
        optlist.Append("} stamp=ll2ur ")
        optlist.AppendFormat("font={0} ", font)
        optlist.Append("fillcolor={lab 100 0 0} gstate={opacityfill=0.5}")
        p.fit_textline("Zebra", 0, 0, optlist.ToString())

        p.close_image(image)

        ' Close all layers
        p.end_layer()

        p.end_page_ext("")
        p.end_document("")

    Catch e As PDFlibException
        Console.Error.WriteLine("PDFlib exception occurred:")
        Console.Error.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)
    Catch e As System.Exception
        Console.Error.WriteLine(e.ToString())
    Finally
        If Not p Is Nothing Then
            p.Dispose()
            p = Nothing
        End If
    End Try
  End Sub
End Module
