'
' PDF portfolio starter:
' Package multiple PDF and other documents into a PDF portfolio.
' The documents in the portfolio will be assigned predefined
' and custom metadata fields; for the custom fields a schema description
' is created.
'
' Required data: PDF and other input documents
'

Imports System
Imports System.Text
Imports PDFlib_dotnet

Structure portfolio
    Public filename As String
    Public description As String
    Public status As String
    Public id As Integer
    ' Constructor
    Public Sub New(ByVal s_filename As String, ByVal s_description As String, _
            ByVal s_status As String, ByVal s_id As Integer)
        filename = s_filename
        description = s_description
        status = s_status
        id = s_id
    End Sub
End Structure

Module starter_portfolio
  Sub Main()
    ' This is where the data files are. Adjust as necessary.
    Dim searchpath As String = "../../../data"
    Dim optlist As New StringBuilder()
    Dim i, font, folder As Integer
        Dim p As PDFlib_dotnet.PDFlib = Nothing

    ' The documents for the Portfolio along with description and metadata
        Dim pf() As portfolio = _
        { _
            New portfolio( _
                "nesrin.jpg", _
                "Zabrisky point", _
                "archived", _
                300 _
            ), _
            New portfolio( _
                "markup_annotations.pdf", _
                "PDF sample with markup annotations", _
                "published", _
                101 _
            ), _
            New portfolio( _
                "pCOS-datasheet.pdf", _
                "PDF Information Retrieval Tool", _
                "published", _
                104 _
            ) _
        }
    Dim n_files As Integer = pf.Length

    Try
        ' create a new PDFlib object
        p = New PDFlib()

        ' This means we must check return values of load_font() etc.
        p.set_option("errorpolicy=return")

        ' Set the search path for fonts and PDF files 
        p.set_option("SearchPath={{" + searchpath + "}}")

            If (p.begin_document("starter_portfolio.pdf", _
                    "") = -1) Then
                Console.WriteLine("Error: {0}\n", p.get_errmsg())
                Return
            End If

            p.set_info("Creator", "PDFlib starter sample")
            p.set_info("Title", "starter_portfolio")

            ' Insert two files in the root folder along with their description
            ' and the following custom fields:
            ' status   string describing the document status
            ' id       numerical identifier, prefixed with "PHX"
            '/
            For i = 0 To 1
                optlist.Length = 0
                optlist.Append("description={")
                optlist.AppendFormat("{0}", pf(i).description)
                optlist.Append("} fieldlist={ {key=status value=")
                optlist.AppendFormat("{0}", pf(i).status)
                optlist.Append("} {key=id value=")
                optlist.AppendFormat("{0}", pf(i).id)
                optlist.Append(" prefix=PHX type=text} }")

                ' -1 means root folder
                p.add_portfolio_file(-1, pf(i).filename, optlist.ToString())
            Next

            ' Create the "datasheets" folder in the root folder
            folder = p.add_portfolio_folder(-1, "datasheets", _
                    "description={Folder with datasheets}")

            ' Insert documents in the "datasheets" folder along with
            ' description and custom fields
            '/
            For i = 2 To n_files - 1 Step 1
                optlist.Length = 0
                optlist.Append("description={")
                optlist.AppendFormat("{0}", pf(i).description)
                optlist.Append("} fieldlist={ {key=status value=")
                optlist.AppendFormat("{0}", pf(i).status)
                optlist.Append("} {key=id value=")
                optlist.AppendFormat("{0}", pf(i).id)
                optlist.Append(" prefix=PHX type=text} }")

                ' Add the file to the "datasheets" folder
                p.add_portfolio_file(folder, pf(i).filename, optlist.ToString())
            Next

            ' Create a single-page document as cover sheet
            p.begin_page_ext(0, 0, "width=a4.width height=a4.height")

            font = p.load_font("NotoSerif-Regular", "unicode", "")
            If (font = -1) Then
                Console.WriteLine("Error: {0}\n", p.get_errmsg())
                Return
            End If

            p.setfont(font, 24)
            p.fit_textline("Welcome to the PDFlib Portfolio sample!", 50, 700, "")

            p.end_page_ext("")

            ' Set options for Portfolio display
            optlist.Length = 0
            optlist.Append("portfolio={initialview=detail ")

            ' Add schema definition for Portfolio metadata
            ' Some predefined fields are included here to make them visible.
            ' User-defined fields
            optlist.Append( _
            "schema={ " & _
            "{order=1 label=Name key=_filename visible editable} " & _
            "{order=2 label=Description key=_description visible} " & _
            "{order=3 label=Size key=_size visible} " & _
            "{order=4 label={Last edited} key=_moddate visible} " & _
            "{order=5 label=Status key=status type=text editable} "&  _
            "{order=6 label=ID key=id type=text editable} ")

            optlist.Append("}}")

            p.end_document(optlist.ToString())

        Catch e As PDFlibException
            Console.Error.WriteLine("PDFlib exception occurred:")
            Console.Error.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)
        Catch e As System.Exception
            Console.Error.WriteLine(e.ToString())
        Finally
            If Not p Is Nothing Then
                p.Dispose()
                p = Nothing
            End If
        End Try
  End Sub
End Module
