' 
' PDFlib Virtual File system (PVF):
' Create a PVF file which holds an image or PDF, and import the data from the
' PVF file
'
' This avoids disk access and is especially useful when the same image or PDF
' is imported multiply. For examples, images which sit in a database don't
' have to be written and re-read from disk, but can be passed to PDFlib
' directly in memory. A similar technique can be used for loading other data
' such as fonts, ICC profiles, etc.
'

Imports System
Imports System.IO
Imports System.Text
Imports PDFlib_dotnet


Module starter_pvf
    Sub Main()
        ' This is where the data files are. Adjust as necessary.'
        Const searchpath As String = "../../../data"
        Const outfile As String = "starter_pvf.pdf"
        Const title As String = "starter_pvf"

        Const svgdata As String = 
            "<?xml version='1.0'?> " &
            "<svg viewBox='0 0 100 100' version='1.1' xmlns='http://www.w3.org/2000/svg'> " &
            "  <circle cx='50' cy='50' r='40' fill='orange'/> " &
            "</svg>"

        Dim p As PDFlib_dotnet.PDFlib = Nothing
        try 
            p = new PDFlib()
            ' This means we must check return values of load_font() etc.
            p.set_option("errorpolicy=return")

            ' Set the search path for fonts and PDF files 
            p.set_option("SearchPath={{" + searchpath + "}}")

            ' Set an output path according to the name of the topic'
            if (p.begin_document(outfile, "") = -1) Then
                Console.WriteLine("Error: " & p.get_errmsg())
                return
            End If

            p.set_info("Creator", "PDFlib starter sample")
            p.set_info("Title", title)

            p.create_pvf("/pvf/svg", System.Text.Encoding.Unicode.GetBytes(svgdata), "")

            ' Load the graphics from the PVF'
            Dim svg As Integer
            svg = p.load_graphics("svg", "/pvf/svg", "")
            if (svg = -1)  Then
                Console.WriteLine("Error: " & p.get_errmsg())
                return
            End If

            ' Fit the graphics on page 1'
            p.begin_page_ext(0,0, "width=a4.width height=a4.height")

            p.fit_graphics(svg, 350, 750, "")

            p.end_page_ext("")

            ' Fit the image on page 2'
            p.begin_page_ext(0,0, "width=a4.width height=a4.height")

            p.fit_graphics(svg, 350, 50, "")

            p.end_page_ext("")

            ' Delete the virtual file to free the allocated memory'

            p.delete_pvf("/pvf/svg")

            p.end_document("")

        Catch e As PDFlibException
            Console.Error.WriteLine("PDFlib exception occurred:")
            Console.Error.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)
        Catch e As System.Exception
            Console.Error.WriteLine(e.ToString())
        Finally
            If Not p Is Nothing Then
                p.Dispose()
                p = Nothing
            End If
        End Try

    End Sub

End Module
