' Starter SVG:
' Load SVG graphics and fit into a box
'
' Required data: SVG graphics


Imports System
Imports System.Text
Imports PDFlib_dotnet

Class starter_svg
    Public Shared Sub Main()
        Dim p As PDFlib_dotnet.PDFlib = Nothing
        ' This is where the data files are. Adjust as necessary. 
        Const searchpath As String = "../../../data"
        Const outfile As String = "starter_svg.pdf"

        Const graphicsfile As String = "PDFlib-logo.svg"
        Dim graphics As Integer

        Const x As Integer = 100
        Const y As Integer = 300
        Const boxwidth As Integer = 400
        Const boxheight As Integer = 400
        Dim optlist As String

        Try
            p = New PDFlib()

            p.set_option("SearchPath={{" + searchpath + "}}")

            ' This means we must check return values of load_graphics() etc. 
            p.set_option("errorpolicy=return")

            If (p.begin_document(outfile, "") = -1) Then
                Throw New Exception("Error: " + p.get_errmsg())
            End If


            p.set_info("Creator", "PDFlib starter sample")
            p.set_info("Title", "starter_svg")

            ' Load the graphics 
            graphics = p.load_graphics("auto", graphicsfile, "")
            If (graphics = -1) Then
                Throw New Exception("Error: " + p.get_errmsg())
            End If


            p.begin_page_ext(0, 0, "width=a4.width height=a4.height")

            ' ------------------------------------------------------
            ' Fit the graphics into a box with proportional resizing
            ' ------------------------------------------------------

            ' The "boxsize" option defines a box with a given width and height 
            ' and its lower left corner located at the reference point.
            ' "position={center}" positions the graphics in the center of the
            ' box.
            ' "fitmethod=meet" resizes the graphics proportionally until its 
            ' height or width completely fits into the box.
            ' The "showborder" option is used to illustrate the borders of the 
            ' box 

            optlist = "boxsize={ " & boxwidth & " " & boxheight & _
               "} position={center} fitmethod=meet showborder"

            ' Before actually fitting the graphics we check whether fitting is
            ' possible.

            If (p.info_graphics(graphics, "fittingpossible", optlist) = 1) Then
                p.fit_graphics(graphics, x, y, optlist)
            Else
                Console.WriteLine("Cannot place graphics: {0}", p.get_errmsg())
            End If


            p.end_page_ext("")

            p.close_graphics(graphics)

            p.end_document("")


        Catch e As PDFlibException
            Console.WriteLine("PDFlib exception occurred in starter_svg sample:")
            Console.WriteLine("[{0}] {1}: {2}", e.get_errnum(), e.get_apiname(), e.get_errmsg)

        Finally
            If Not p Is Nothing Then
                p.Dispose()
            End If
        End Try

    End Sub
End Class
